/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class ModuleJarMetadata
implements JarMetadata {
    private final ModuleDescriptor descriptor;

    public ModuleJarMetadata(URI uri, Set<String> packages) {
        try (InputStream is = Files.newInputStream(Path.of(uri), new OpenOption[0]);){
            ClassReader cr = new ClassReader(is);
            ModuleClassVisitor mcv = new ModuleClassVisitor();
            cr.accept((ClassVisitor)mcv, 1);
            mcv.mfv().packages().addAll(packages);
            mcv.mfv().builder().packages(mcv.mfv.packages());
            this.descriptor = mcv.mfv().builder().build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String name() {
        return this.descriptor.name();
    }

    @Override
    public String version() {
        return this.descriptor.version().toString();
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    private class ModuleClassVisitor
    extends ClassVisitor {
        private ModFileVisitor mfv;

        ModuleClassVisitor() {
            super(589824);
        }

        public ModuleVisitor visitModule(String name, int access, String version) {
            this.mfv = new ModFileVisitor(name, access, version);
            return this.mfv;
        }

        public ModFileVisitor mfv() {
            return this.mfv;
        }
    }

    private class ModFileVisitor
    extends ModuleVisitor {
        private final ModuleDescriptor.Builder builder;
        private final Set<String> packages;

        public ModFileVisitor(String name, int access, String version) {
            super(589824);
            this.packages = new HashSet<String>();
            this.builder = ModuleDescriptor.newOpenModule(name);
            if (version != null) {
                this.builder.version(version);
            }
        }

        public void visitExport(String packaze, int access, String ... modules) {
            if (modules != null) {
                this.builder.exports(packaze.replace('/', '.'), Set.of(modules));
            } else {
                this.builder.exports(packaze.replace('/', '.'));
            }
        }

        public void visitMainClass(String mainClass) {
            this.builder.mainClass(mainClass.replace('/', '.'));
        }

        public void visitOpen(String packaze, int access, String ... modules) {
        }

        public void visitPackage(String packaze) {
            this.packages.add(packaze.replace('/', '.'));
        }

        public void visitProvide(String service, String ... providers) {
            this.builder.provides(service.replace('/', '.'), Arrays.stream(providers).map(s -> s.replace('/', '.')).toList());
        }

        public void visitRequire(String module, int access, String version) {
            Set<ModuleDescriptor.Requires.Modifier> mods;
            if (access == 0) {
                mods = Set.of();
            } else {
                mods = new HashSet();
                if ((access & 0x20) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.TRANSITIVE);
                }
                if ((access & 0x40) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.STATIC);
                }
                if ((access & 0x1000) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.SYNTHETIC);
                }
                if ((access & 0x8000) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.MANDATED);
                }
            }
            if (version != null) {
                this.builder.requires(mods, module, ModuleDescriptor.Version.parse(version));
            } else {
                this.builder.requires(mods, module);
            }
        }

        public void visitUse(String service) {
            this.builder.uses(service.replace('/', '.'));
        }

        ModuleDescriptor.Builder builder() {
            return this.builder;
        }

        public Set<String> packages() {
            return this.packages;
        }
    }
}

