/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    protected Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    protected Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void load(CompoundTag var1);

    public abstract void save(CompoundTag var1, T var2);

    public void save(CompoundTag tag) {
        this.save(tag, this.value);
    }

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String getKey(String denotation) {
        return "option." + denotation + "." + this.getName();
    }

    public String getDescriptionKey(String denotation) {
        return this.getKey(denotation) + ".description";
    }

    public Component getDefaultInfo() {
        return Component.m_237110_((String)"securitycraft.option.default_with_range", (Object[])new Object[]{this.getDefaultValue(), this.getMin(), this.getMax()}).m_130940_(ChatFormatting.GRAY);
    }

    public Component getValueText() {
        return Component.m_237113_((String)this.toString());
    }

    public String toString() {
        return "" + this.value;
    }

    public EntityDataWrappedOption<T> wrapForEntityData(EntityDataAccessor<T> entityDataKey, Supplier<SynchedEntityData> entityData) {
        return new EntityDataWrappedOption<T>(this, entityDataKey, entityData);
    }

    public static class EntityDataWrappedOption<T>
    extends Option<T> {
        private final Option<T> wrapped;
        private final EntityDataAccessor<T> entityDataKey;
        private final Supplier<SynchedEntityData> entityData;

        public EntityDataWrappedOption(Option<T> wrapped, EntityDataAccessor<T> entityDataKey, Supplier<SynchedEntityData> entityData) {
            super(wrapped.getName(), wrapped.getDefaultValue());
            this.wrapped = wrapped;
            this.entityDataKey = entityDataKey;
            this.entityData = entityData;
        }

        @Override
        public void toggle() {
            this.wrapped.toggle();
        }

        @Override
        public void load(CompoundTag tag) {
            this.wrapped.load(tag);
            this.entityData.get().m_135381_(this.entityDataKey, this.wrapped.get());
        }

        @Override
        public void save(CompoundTag tag, T value) {
            this.wrapped.save(tag, value);
        }

        @Override
        public void save(CompoundTag tag) {
            this.wrapped.save(tag, this.entityData.get().m_135370_(this.entityDataKey));
        }

        @Override
        public void copy(Option<?> option) {
            this.wrapped.copy(option);
        }

        @Override
        public final String getName() {
            return this.wrapped.getName();
        }

        @Override
        public T get() {
            return this.wrapped.get();
        }

        @Override
        public void setValue(T value) {
            this.wrapped.setValue(value);
            this.entityData.get().m_135381_(this.entityDataKey, this.wrapped.get());
        }

        @Override
        public T getDefaultValue() {
            return this.wrapped.getDefaultValue();
        }

        @Override
        public T getIncrement() {
            return this.wrapped.getIncrement();
        }

        @Override
        public T getMin() {
            return this.wrapped.getMin();
        }

        @Override
        public T getMax() {
            return this.wrapped.getMax();
        }

        @Override
        public boolean isSlider() {
            return this.wrapped.isSlider();
        }

        @Override
        public String getKey(String denotation) {
            return this.wrapped.getKey(denotation);
        }

        @Override
        public String getDescriptionKey(String denotation) {
            return this.wrapped.getDescriptionKey(denotation);
        }

        @Override
        public Component getDefaultInfo() {
            return this.wrapped.getDefaultInfo();
        }

        @Override
        public Component getValueText() {
            return this.wrapped.getValueText();
        }

        @Override
        public String toString() {
            return this.wrapped.toString();
        }

        public Option<T> getWrapped() {
            return this.wrapped;
        }

        public EntityDataAccessor<T> getEntityDataKey() {
            return this.entityDataKey;
        }
    }

    public static class TargetingModeOption
    extends EnumOption<TargetingMode> {
        public TargetingModeOption(TargetingMode defaultValue) {
            super("targetingMode", defaultValue, TargetingMode.class);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.targetingMode";
        }

        @Override
        public Component getValueText() {
            return ((TargetingMode)((Object)this.value)).translate();
        }
    }

    public static class EnumOption<T extends Enum<T>>
    extends Option<T> {
        private final Class<T> enumClass;

        public EnumOption(String optionName, T value, Class<T> enumClass) {
            super(optionName, value);
            this.enumClass = enumClass;
        }

        @Override
        public void toggle() {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int next = (((Enum)this.value).ordinal() + 1) % enumConstants.length;
            this.value = enumConstants[next];
        }

        @Override
        public void load(CompoundTag tag) {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int ordinal = tag.m_128451_(this.getName());
            this.value = ordinal >= 0 && ordinal < enumConstants.length ? enumConstants[ordinal] : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag, T value) {
            tag.m_128405_(this.getName(), ((Enum)value).ordinal());
        }

        @Override
        public Component getValueText() {
            return Component.m_237113_((String)((Enum)this.value).name());
        }

        @Override
        public Component getDefaultInfo() {
            return Component.m_237110_((String)"securitycraft.option.default", (Object[])new Object[]{this.getValueText()}).m_130940_(ChatFormatting.GRAY);
        }
    }

    public static class DoubleOption
    extends Option<Double> {
        public DoubleOption(String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Double.valueOf(tag.m_128459_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag, Double value) {
            tag.m_128347_(this.getName(), value.doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return true;
        }
    }

    public static class SignalLengthOption
    extends IntOption {
        public SignalLengthOption(int defaultLength) {
            super("signalLength", defaultLength, 0, 400, 5);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.signalLength";
        }
    }

    public static class SmartModuleCooldownOption
    extends IntOption {
        public SmartModuleCooldownOption() {
            super("smartModuleCooldown", 100, 20, 400, 1);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.smartModuleCooldown";
        }
    }

    public static class IntOption
    extends Option<Integer> {
        public IntOption(String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
        }

        @Override
        public void toggle() {
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Integer.valueOf(tag.m_128451_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag, Integer value) {
            tag.m_128405_(this.getName(), value.intValue());
        }

        @Override
        public boolean isSlider() {
            return true;
        }
    }

    public static class SendDenylistMessageOption
    extends BooleanOption {
        public SendDenylistMessageOption(Boolean value) {
            super("sendDenylistMessage", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.sendDenylistMessage";
        }
    }

    public static class SendAllowlistMessageOption
    extends BooleanOption {
        public SendAllowlistMessageOption(Boolean value) {
            super("sendAllowlistMessage", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.sendAllowlistMessage";
        }
    }

    public static class RespectInvisibilityOption
    extends BooleanOption {
        public RespectInvisibilityOption() {
            this(false);
        }

        public RespectInvisibilityOption(Boolean value) {
            super("respectInvisibility", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.respectInvisibility";
        }

        public boolean isConsideredInvisible(LivingEntity entity) {
            return (Boolean)this.get() != false && entity.m_21023_(MobEffects.f_19609_);
        }
    }

    public static class IgnoreOwnerOption
    extends BooleanOption {
        public IgnoreOwnerOption(Boolean value) {
            super("ignoreOwner", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.ignoreOwner";
        }
    }

    public static class DisabledOption
    extends BooleanOption {
        public DisabledOption(Boolean value) {
            super("disabled", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.disabled";
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void load(CompoundTag tag) {
            this.value = tag.m_128441_(this.getName()) ? Boolean.valueOf(tag.m_128471_(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(CompoundTag tag, Boolean value) {
            tag.m_128379_(this.getName(), value.booleanValue());
        }

        @Override
        public Component getDefaultInfo() {
            return Component.m_237110_((String)"securitycraft.option.default", (Object[])new Object[]{Component.m_237115_((String)((Boolean)this.getDefaultValue() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no"))}).m_130940_(ChatFormatting.GRAY);
        }

        @Override
        public Component getValueText() {
            return Component.m_237115_((String)((Boolean)this.get() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no"));
        }
    }
}

