/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.hudmods;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.SecuritySeaBoat;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HudModHandler {
    protected static final ResourceLocation SHOW_OWNER = new ResourceLocation("securitycraft", "showowner");
    protected static final ResourceLocation SHOW_MODULES = new ResourceLocation("securitycraft", "showmodules");
    protected static final ResourceLocation SHOW_CUSTOM_NAME = new ResourceLocation("securitycraft", "showcustomname");
    protected static final Style MOD_NAME_STYLE = Style.f_131099_.m_131157_(ChatFormatting.BLUE).m_131155_(Boolean.valueOf(true));
    protected static final Style ITEM_NAME_STYLE = Style.f_131099_.m_131157_(ChatFormatting.WHITE);
    protected static final MutableComponent EQUIPPED = Utils.localize("waila.securitycraft:equipped", new Object[0]).m_130940_(ChatFormatting.GRAY);
    protected static final MutableComponent ALLOWLIST_MODULE = Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)ModuleType.ALLOWLIST.getTranslationKey())).m_130940_(ChatFormatting.GRAY);
    protected static final MutableComponent DISGUISE_MODULE = Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)ModuleType.DISGUISE.getTranslationKey())).m_130940_(ChatFormatting.GRAY);
    protected static final MutableComponent SPEED_MODULE = Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)ModuleType.SPEED.getTranslationKey())).m_130940_(ChatFormatting.GRAY);

    protected HudModHandler() {
    }

    public void addDisguisedOwnerModuleNameInfo(Level level, BlockPos pos, BlockState state, Block block, BlockEntity be, Player player, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        Optional<BlockState> disguisedBlockState;
        if (be == null) {
            return;
        }
        if (block instanceof IDisguisable && (disguisedBlockState = IDisguisable.getDisguisedBlockState(be, (LevelReader)level)).isPresent()) {
            IOverlayDisplay display;
            BlockState disguisedState = disguisedBlockState.get();
            block = disguisedState.m_60734_();
            if (block instanceof EntityBlock) {
                EntityBlock entityBlock = (EntityBlock)block;
                if (!(block instanceof IDisguisable) && entityBlock.m_142194_(pos, disguisedState) instanceof IOwnable) {
                    this.addOwnerInfo(be, lineAdder, configGetter);
                }
            }
            if (!(block instanceof IOverlayDisplay) || !(display = (IOverlayDisplay)block).shouldShowSCInfo(level, state, pos)) {
                return;
            }
        }
        if (!(block instanceof IBlockMine)) {
            this.addOwnerModuleNameInfo(be, player, lineAdder, configGetter);
        }
    }

    public void addOwnerInfo(Object obj, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        if (configGetter.test(SHOW_OWNER) && obj instanceof IOwnable) {
            IOwnable ownable = (IOwnable)obj;
            lineAdder.accept((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(ownable.getOwner())).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void addOwnerModuleNameInfo(Object obj, Player player, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        Nameable nameable;
        IOwnable ownable;
        IModuleInventory inv;
        this.addOwnerInfo(obj, lineAdder, configGetter);
        if (configGetter.test(SHOW_MODULES) && obj instanceof IModuleInventory && !(inv = (IModuleInventory)obj).getInsertedModules().isEmpty() && (!(obj instanceof IOwnable) || (ownable = (IOwnable)obj).isOwnedBy((Entity)player))) {
            lineAdder.accept((Component)EQUIPPED);
            for (ModuleType module : inv.getInsertedModules()) {
                MutableComponent prefix = inv.isModuleEnabled(module) ? Component.m_237113_((String)"\u2714 ").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"\u2715 ").m_130940_(ChatFormatting.RED);
                lineAdder.accept((Component)prefix.m_7220_((Component)Component.m_237115_((String)module.getTranslationKey()).m_130940_(ChatFormatting.GRAY)));
            }
        }
        if (configGetter.test(SHOW_CUSTOM_NAME) && obj instanceof Nameable && (nameable = (Nameable)obj).m_8077_()) {
            Component text = nameable.m_7770_();
            MutableComponent name = text == null ? Component.m_237119_() : text;
            lineAdder.accept((Component)Utils.localize("waila.securitycraft:customName", name).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void addEntityInfo(Entity entity, Player player, Consumer<Component> lineAdder, Predicate<ResourceLocation> configGetter) {
        if (entity instanceof Sentry) {
            Sentry sentry = (Sentry)entity;
            Sentry.SentryMode mode = sentry.getMode();
            this.addOwnerInfo(sentry, lineAdder, configGetter);
            if (configGetter.test(SHOW_MODULES) && sentry.isOwnedBy((Entity)player) && (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule())) {
                lineAdder.accept((Component)EQUIPPED);
                if (!sentry.getAllowlistModule().m_41619_()) {
                    lineAdder.accept((Component)ALLOWLIST_MODULE);
                }
                if (!sentry.getDisguiseModule().m_41619_()) {
                    lineAdder.accept((Component)DISGUISE_MODULE);
                }
                if (sentry.hasSpeedModule()) {
                    lineAdder.accept((Component)SPEED_MODULE);
                }
            }
            MutableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
            if (mode != Sentry.SentryMode.IDLE) {
                modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
            }
            lineAdder.accept((Component)modeDescription.m_130940_(ChatFormatting.GRAY));
        } else if (entity instanceof SecuritySeaBoat) {
            SecuritySeaBoat boat = (SecuritySeaBoat)entity;
            this.addOwnerModuleNameInfo(boat, player, lineAdder, configGetter);
        }
    }
}

