/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;

public enum TargetingMode {
    PLAYERS("gui.securitycraft:srat.targets3"),
    PLAYERS_AND_MOBS("gui.securitycraft:srat.targets1"),
    MOBS("gui.securitycraft:srat.targets2");

    private final String translationKey;

    private TargetingMode(String translationKey) {
        this.translationKey = translationKey;
    }

    public Component translate() {
        return Component.m_237115_((String)this.translationKey);
    }

    public boolean allowsPlayers() {
        return this == PLAYERS || this == PLAYERS_AND_MOBS;
    }

    public boolean allowsMobs() {
        return this == MOBS || this == PLAYERS_AND_MOBS;
    }

    public <T extends IOwnable> boolean canAttackEntity(LivingEntity entity, T be, Predicate<LivingEntity> isInvisible) {
        IModuleInventory moduleInv;
        if (entity == null || be instanceof IModuleInventory && (moduleInv = (IModuleInventory)((Object)be)).isAllowed((Entity)entity)) {
            return false;
        }
        boolean isPlayer = entity instanceof Player;
        if (isPlayer && this.allowsPlayers() || !isPlayer && this.allowsMobs()) {
            OwnableEntity ownableEntity;
            return !(isPlayer && (be.isOwnedBy((Entity)entity) && be.ignoresOwner() || ((Player)entity).m_7500_()) || !entity.m_142065_() || isInvisible.test(entity) || entity instanceof OwnableEntity && be.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity));
        }
        return false;
    }
}

