/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CustomizeBlockScreen
extends AbstractContainerScreen<CustomizeBlockMenu>
implements IHasExtraAreas,
ContainerListener {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private final int maxNumberOfModules;
    private final ResourceLocation texture;
    private final PictureButton[] descriptionButtons;
    private IModuleInventory moduleInv;
    private AbstractWidget[] optionButtons;
    private EnumMap<ModuleType, Boolean> indicators = new EnumMap(ModuleType.class);

    public CustomizeBlockScreen(CustomizeBlockMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.moduleInv = menu.moduleInv;
        this.maxNumberOfModules = this.moduleInv.getMaxNumberOfModules();
        this.texture = new ResourceLocation("securitycraft", "textures/gui/container/customize" + this.maxNumberOfModules + ".png");
        this.descriptionButtons = new PictureButton[this.maxNumberOfModules];
        menu.m_38893_(this);
        for (ModuleType type : ModuleType.values()) {
            if (this.moduleInv.hasModule(type)) {
                this.indicators.put(type, this.moduleInv.isModuleEnabled(type));
                continue;
            }
            this.indicators.put(type, true);
        }
    }

    public void m_7856_() {
        ICustomizable customizable;
        Option<?>[] options;
        super.m_7856_();
        int numberOfColumns = 2;
        for (int i = 0; i < this.maxNumberOfModules; ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = (PictureButton)this.m_142416_((GuiEventListener)new ModuleButton(this.f_97735_ + 127 + column * 22, this.f_97736_ + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.moduleInv.acceptedModules()[i].getItem(), this::moduleButtonClicked));
            this.descriptionButtons[i].m_257544_(Tooltip.m_257550_((Component)this.getModuleTooltipText(i)));
            this.descriptionButtons[i].f_93623_ = this.moduleInv.hasModule(this.moduleInv.acceptedModules()[i]);
        }
        IModuleInventory column = this.moduleInv;
        if (column instanceof ICustomizable && (options = (customizable = (ICustomizable)((Object)column)).customOptions()).length > 0) {
            this.optionButtons = new AbstractWidget[options.length];
            for (int i = 0; i < options.length; ++i) {
                Option<?> option;
                Option<?> option2 = options[i];
                if (option2 instanceof Option.EntityDataWrappedOption) {
                    Option.EntityDataWrappedOption wrapped = (Option.EntityDataWrappedOption)option2;
                    v0 = wrapped.getWrapped();
                } else {
                    v0 = option = options[i];
                }
                if (option.isSlider()) {
                    if (option instanceof Option.DoubleOption) {
                        Option.DoubleOption doubleOption = (Option.DoubleOption)option;
                        sliderIndex = i;
                        this.optionButtons[i] = new CallbackSlider(this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, (Component)Utils.localize(option.getKey(Utils.getLanguageKeyDenotation(this.moduleInv)), ""), (Component)Component.m_237119_(), (Double)doubleOption.getMin(), (Double)doubleOption.getMax(), (Double)doubleOption.get(), (Double)doubleOption.getIncrement(), 0, true, slider -> {
                            doubleOption.setValue(slider.getValue());
                            this.optionButtons[sliderIndex].m_257544_(Tooltip.m_257550_((Component)this.getOptionDescription(sliderIndex)));
                            if (((CustomizeBlockMenu)this.f_97732_).entityId == -1) {
                                SecurityCraft.CHANNEL.sendToServer((Object)new UpdateSliderValue(this.moduleInv.myPos(), option, (double)((Double)doubleOption.get())));
                            } else {
                                SecurityCraft.CHANNEL.sendToServer((Object)new UpdateSliderValue(((CustomizeBlockMenu)this.f_97732_).entityId, option, (double)((Double)doubleOption.get())));
                            }
                        }){

                            protected void m_5695_() {
                                this.m_93666_(CustomizeBlockScreen.this.getOptionButtonTitle(option));
                            }
                        };
                    } else if (option instanceof Option.IntOption) {
                        Option.IntOption intOption = (Option.IntOption)option;
                        sliderIndex = i;
                        this.optionButtons[i] = new CallbackSlider(this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, (Component)Utils.localize(option.getKey(Utils.getLanguageKeyDenotation(this.moduleInv)), ""), (Component)Component.m_237119_(), (double)((Integer)intOption.getMin()).intValue(), (double)((Integer)intOption.getMax()).intValue(), (double)((Integer)intOption.get()).intValue(), true, slider -> {
                            intOption.setValue(slider.getValueInt());
                            this.optionButtons[sliderIndex].m_257544_(Tooltip.m_257550_((Component)this.getOptionDescription(sliderIndex)));
                            if (((CustomizeBlockMenu)this.f_97732_).entityId == -1) {
                                SecurityCraft.CHANNEL.sendToServer((Object)new UpdateSliderValue(this.moduleInv.myPos(), option, (double)((Integer)intOption.get()).intValue()));
                            } else {
                                SecurityCraft.CHANNEL.sendToServer((Object)new UpdateSliderValue(((CustomizeBlockMenu)this.f_97732_).entityId, option, (double)((Integer)intOption.get()).intValue()));
                            }
                        }){

                            protected void m_5695_() {
                                this.m_93666_(CustomizeBlockScreen.this.getOptionButtonTitle(option));
                            }
                        };
                    }
                    this.optionButtons[i].setFGColor(0xE0E0E0);
                } else {
                    this.optionButtons[i] = new Button(this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::optionButtonClicked, Button.f_252438_);
                    this.optionButtons[i].setFGColor(option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
                }
                this.m_142416_((GuiEventListener)this.optionButtons[i]);
                this.optionButtons[i].m_257544_(Tooltip.m_257550_((Component)this.getOptionDescription(i)));
            }
            for (AbstractWidget button : this.optionButtons) {
                this.extraAreas.add(new Rect2i(button.m_252754_(), button.m_252907_(), button.m_5711_(), button.m_93694_()));
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 36; i < ((CustomizeBlockMenu)this.f_97732_).getMaxSlots(); ++i) {
            ModuleType type;
            Slot slot = (Slot)((CustomizeBlockMenu)this.f_97732_).f_38839_.get(i);
            if (slot.m_7993_().m_41619_() || !this.indicators.containsKey((Object)(type = ((ModuleItem)slot.m_7993_().m_41720_()).getModuleType()))) continue;
            guiGraphics.m_280411_(BEACON_GUI, this.f_97735_ + slot.f_40220_ - 2, this.f_97736_ + slot.f_40221_ + 16, 20, 20, this.indicators.get((Object)type) != false ? 88.0f : 110.0f, 219.0f, 21, 22, 256, 256);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, Utils.INVENTORY_TEXT, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(this.texture, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
        if (slotIndex < 36) {
            return;
        }
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            if (this.descriptionButtons[i] == null) continue;
            ModuleType type = this.moduleInv.acceptedModules()[i];
            this.descriptionButtons[i].f_93623_ = this.moduleInv.hasModule(type);
            if (!this.descriptionButtons[i].f_93623_) {
                this.indicators.remove((Object)type);
                continue;
            }
            this.indicators.computeIfAbsent(type, t -> true);
        }
    }

    private void moduleButtonClicked(Button button) {
        ModuleType moduleType = ((ModuleButton)button).getModule().getModuleType();
        if (this.moduleInv.isModuleEnabled(moduleType)) {
            this.indicators.put(moduleType, false);
            this.moduleInv.removeModule(moduleType, true);
        } else {
            this.indicators.put(moduleType, true);
            this.moduleInv.insertModule(this.moduleInv.getModule(moduleType), true);
        }
        if (((CustomizeBlockMenu)this.f_97732_).entityId == -1) {
            SecurityCraft.CHANNEL.sendToServer((Object)new ToggleModule(this.moduleInv.myPos(), moduleType));
        } else {
            SecurityCraft.CHANNEL.sendToServer((Object)new ToggleModule(((CustomizeBlockMenu)this.f_97732_).entityId, moduleType));
        }
    }

    private void optionButtonClicked(Button button) {
        for (int i = 0; i < this.optionButtons.length; ++i) {
            if (button != this.optionButtons[i]) continue;
            Option<?> tempOption = ((ICustomizable)((Object)this.moduleInv)).customOptions()[i];
            tempOption.toggle();
            button.setFGColor(tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
            button.m_93666_(this.getOptionButtonTitle(tempOption));
            this.optionButtons[i].m_257544_(Tooltip.m_257550_((Component)this.getOptionDescription(i)));
            if (((CustomizeBlockMenu)this.f_97732_).entityId == -1) {
                SecurityCraft.CHANNEL.sendToServer((Object)new ToggleOption(this.moduleInv.myPos(), i));
            } else {
                SecurityCraft.CHANNEL.sendToServer((Object)new ToggleOption(((CustomizeBlockMenu)this.f_97732_).entityId, i));
            }
            return;
        }
    }

    private Component getModuleTooltipText(int moduleId) {
        return Utils.localize(this.descriptionButtons[moduleId].getItemStack().m_41778_(), new Object[0]).m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.RESET).m_7220_((Component)Component.m_237113_((String)"\n\n")).m_7220_((Component)Utils.localize(this.moduleInv.getModuleDescriptionId(Utils.getLanguageKeyDenotation(this.moduleInv), ((ModuleItem)this.descriptionButtons[moduleId].getItemStack().m_41720_()).getModuleType()), new Object[0]));
    }

    private Component getOptionDescription(int optionId) {
        Option<?> option = ((ICustomizable)((Object)this.moduleInv)).customOptions()[optionId];
        return Utils.localize("gui.securitycraft:customize.tooltip", Component.m_237115_((String)option.getDescriptionKey(Utils.getLanguageKeyDenotation(this.moduleInv))), Component.m_237110_((String)"gui.securitycraft:customize.currentSetting", (Object[])new Object[]{option.getValueText()}));
    }

    private Component getOptionButtonTitle(Option<?> option) {
        return Utils.localize(option.getKey(Utils.getLanguageKeyDenotation(this.moduleInv)), option.getValueText());
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public void m_142153_(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    private class ModuleButton
    extends PictureButton {
        private final ModuleItem module;

        public ModuleButton(int xPos, int yPos, int width, int height, ModuleItem itemToRender, Button.OnPress onPress) {
            super(xPos, yPos, width, height, new ItemStack((ItemLike)itemToRender), onPress);
            this.module = itemToRender;
        }

        public ModuleItem getModule() {
            return this.module;
        }
    }
}

