/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.overlay;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.event.EventSystem;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.screens.player.OverlayScreen;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class OxygenCanOverlay {
    public static final EventSystem<ShouldRenderEventListener> SHOULD_RENDER_EVENT = new EventSystem();
    public static final String OXYGENCAN_DESCRIPTION_ID = Util.m_137492_((String)"item", (ResourceLocation)AddonItems.OXYGEN_CAN.getId());
    public static final Component INFINITY_TEXT = Component.m_237115_((String)TranslationUtils.CREATIVE_OXYGEN_INFINITY);

    public static Component getOxygenComponent(double ratio) {
        Component text = OxygenCanOverlay.getRatioText(ratio);
        return Component.m_237115_((String)OXYGENCAN_DESCRIPTION_ID).m_130946_(": ").m_7220_(text).m_130938_(s -> s.m_178520_(Mth.m_14169_((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f)));
    }

    public static Component getRatioText(double ratio) {
        return ratio == Double.POSITIVE_INFINITY ? INFINITY_TEXT : TranslationUtils.formatPercent(ratio);
    }

    public static boolean shouldRender(LocalPlayer player) {
        for (ShouldRenderEventListener listener : SHOULD_RENDER_EVENT.getListeners()) {
            if (!listener.shouldRender(player)) continue;
            return true;
        }
        return false;
    }

    public static void renderHud(GuiGraphics guiGraphics, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        if (minecraft.f_91066_.f_92063_) {
            return;
        }
        if (SpaceSuitItem.hasFullSet((LivingEntity)player) && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof SpaceSuitItem) {
            OxygenStorageUtils.getStoredRatio(OxygenStorageUtils.stream((LivingEntity)player).filter(item -> {
                IOxygenCharger oxygenCharger = OxygenChargerUtils.get(item);
                return oxygenCharger != null && oxygenCharger.getChargeMode().contains(EquipmentSlot.CHEST);
            })).ifPresent(ratio -> {
                Font font = minecraft.f_91062_;
                Component text = OxygenCanOverlay.getOxygenComponent(ratio);
                int textureWidth = 62;
                int textureHeight = 52;
                int textWidth = font.m_92852_((FormattedText)text);
                int textX = (int)((float)AdAstraConfigClient.oxygenBarX + (float)(textureWidth - textWidth) / 2.0f);
                Objects.requireNonNull(font);
                int textY = AdAstraConfigClient.oxygenBarY + textureHeight + 9 + 3;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(AdAstraConfigClient.oxygenBarScale, AdAstraConfigClient.oxygenBarScale, AdAstraConfigClient.oxygenBarScale);
                guiGraphics.m_280430_(font, text, Math.max(textX, 0), textY, 0xFFFFFF);
                guiGraphics.m_280168_().m_85849_();
            });
        } else if (OxygenCanOverlay.shouldRender(player)) {
            OxygenStorageUtils.getStoredRatio((LivingEntity)player).ifPresent(ratio -> OxygenCanOverlay.renderOxygenCanTank(guiGraphics, minecraft, ratio));
        }
    }

    public static void renderOxygenCanTank(GuiGraphics graphics, Minecraft minecraft, double oxygenRatio) {
        int textureWidth = 62;
        int textureHeight = 52;
        int barHeight = (int)(Math.min(oxygenRatio, 1.0) * (double)textureHeight);
        int x = AdAstraConfigClient.oxygenBarX;
        int y = AdAstraConfigClient.oxygenBarY;
        float scale = AdAstraConfigClient.oxygenBarScale;
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        graphics.m_280163_(OverlayScreen.OXYGEN_TANK_EMPTY, x, y, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        graphics.m_280163_(OverlayScreen.OXYGEN_TANK, x, y + textureHeight - barHeight, 0.0f, (float)(textureHeight - barHeight), textureWidth, barHeight, textureWidth, textureHeight);
        Font font = minecraft.f_91062_;
        Component text = OxygenCanOverlay.getOxygenComponent(oxygenRatio);
        int textWidth = font.m_92852_((FormattedText)text);
        int textX = (int)((float)x + (float)(textureWidth - textWidth) / 2.0f);
        int textY = y + textureHeight + 3;
        graphics.m_280430_(font, text, Math.max(textX, 0), textY, 0xFFFFFF);
        poseStack.m_85849_();
    }

    static {
        SHOULD_RENDER_EVENT.register(player -> EnchantmentHelper.m_44836_((Enchantment)AddonEnchantments.OXYGEN_PROOF.get(), (LivingEntity)player) > 0);
    }

    @FunctionalInterface
    public static interface ShouldRenderEventListener {
        public boolean shouldRender(LocalPlayer var1);
    }
}

