/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.MotionControllers;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientPlayerTarget
extends EntityTarget<AbstractClientPlayer> {
    private static final Optional<Field> noJumpDelay;
    public float swingStrength = 0.15f * MotionControllers.getMainFactor();
    protected Vect3d durableMotion = Vect3d.ZERO;
    protected int duration;
    protected boolean swinging;

    public ClientPlayerTarget(AbstractClientPlayer target, double damping) {
        super(target, damping);
    }

    @Override
    public boolean exists() {
        return super.exists() || ((AbstractClientPlayer)this.target).m_6084_() && this.durableMotion.notZero();
    }

    public void setDurableMotion(Vect3d motion, int duration) {
        this.durableMotion = motion;
        this.duration = duration;
    }

    public int getNoJumpDelay() {
        if (noJumpDelay.isPresent()) {
            try {
                return noJumpDelay.get().getInt(this.target);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public void updateSwinging() {
        this.swinging = !((AbstractClientPlayer)this.target).m_20096_() && !((AbstractClientPlayer)this.target).m_20069_() && this.getNoJumpDelay() == 0 && (!((AbstractClientPlayer)this.target).m_7500_() || !((AbstractClientPlayer)this.target).m_150110_().f_35935_);
    }

    protected Vect3d getSwingMotion() {
        Vect3d motion = ForgeEntity.getMotion((Entity)this.target);
        Vect3d movement = Vect3d.from((double)((AbstractClientPlayer)this.target).f_20900_, (double)0.0, (double)((AbstractClientPlayer)this.target).f_20902_).rotateAroundY(-((AbstractClientPlayer)this.target).m_146908_());
        if (Vect3d.scalarMult((Vect3d)movement, (Vect3d)motion) < 0.0) {
            return Vect3d.ZERO;
        }
        return movement.projectOn(motion).scale((double)this.swingStrength);
    }

    @Override
    public void applyMotions() {
        if (this.swinging) {
            this.addDampedMotion(this.getSwingMotion());
        }
        this.swinging = false;
        if (this.duration > 0) {
            --this.duration;
            this.addDampedMotion(this.durableMotion);
        } else {
            this.durableMotion = Vect3d.ZERO;
        }
        super.applyMotions();
    }

    static {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"f_20954_");
        }
        catch (Exception exception) {
            // empty catch block
        }
        noJumpDelay = Optional.ofNullable(field);
    }
}

