/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.properties;

import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.properties.synched.SynchedProperties;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.properties.HookType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SynchronizedProperties
extends ForgeNetMsg<SynchronizedProperties> {
    public HookType hookType;
    public CompoundTag compound;

    public SynchronizedProperties() {
    }

    public SynchronizedProperties create() {
        return new SynchronizedProperties();
    }

    public SynchronizedProperties(HookType hookType) {
        this.hookType = hookType;
        this.compound = new CompoundTag();
        hookType.synchedProperties().forEach(props -> props.writeTo(this.compound));
    }

    public static void resetToConfigValues() {
        for (HookType type : HookType.values()) {
            type.synchedProperties().forEach(SynchedProperties::resetToConfigValues);
        }
    }

    public static void loadData() {
        for (HookType type : HookType.values()) {
            type.synchedProperties().forEach(SynchedProperties::loadData);
        }
    }

    public static void syncWithPlayer(ServerPlayer player) {
        for (HookType type : HookType.values()) {
            new SynchronizedProperties(type).sendToPlayer(player);
        }
    }

    public static void syncWithAllPlayersAndReload() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            SynchronizedProperties.resetToConfigValues();
            server.m_6846_().m_11314_().forEach(SynchronizedProperties::syncWithPlayer);
        }
        SynchronizedProperties.loadData();
    }

    public void handle(Level level, Player player) {
        this.hookType.synchedProperties().forEach(props -> props.readFrom(this.compound));
    }

    public void sendToPlayer(ServerPlayer player) {
        AdHooks.getInstance().getConnection().sendToPlayer((Object)this, player);
    }
}

