/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.BlockDefinition;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import net.pedroksl.advanced_ae.common.definitions.AAEItemDefinition;

public class AAEBlockDefinition<T extends Block>
implements ItemLike {
    private final String englishName;
    private final RegistryObject<T> block;
    private final AAEItemDefinition<BlockItem> item;

    public AAEBlockDefinition(String englishName, RegistryObject<T> block, AAEItemDefinition<BlockItem> item) {
        this.englishName = englishName;
        this.item = Objects.requireNonNull(item, "item");
        this.block = Objects.requireNonNull(block, "block");
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public ResourceLocation id() {
        return this.block.getId();
    }

    public final T block() {
        return (T)((Block)this.block.get());
    }

    public ItemStack stack() {
        return this.item.stack();
    }

    public ItemStack stack(int stackSize) {
        return this.item.stack(stackSize);
    }

    public GenericStack genericStack(long stackSize) {
        return this.item.genericStack(stackSize);
    }

    public boolean is(ItemStack comparableStack) {
        return this.item.is(comparableStack);
    }

    public boolean is(AEKey key) {
        return this.item.is(key);
    }

    public AAEItemDefinition<BlockItem> item() {
        return this.item;
    }

    public BlockItem asItem() {
        return this.item.m_5456_();
    }

    public BlockDefinition<T> getBlockDefinition() {
        return new BlockDefinition(this.englishName, this.id(), this.block(), this.asItem());
    }
}

