/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.pedroksl.advanced_ae.common.definitions.AAEItemDefinition;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;
import net.pedroksl.advanced_ae.common.fluids.QuantumInfusionBlock;
import net.pedroksl.advanced_ae.common.fluids.QuantumInfusionFluid;
import net.pedroksl.advanced_ae.common.fluids.QuantumInfusionFluidType;

public class AAEFluids {
    public static final DeferredRegister<FluidType> DR_FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"advanced_ae");
    public static final DeferredRegister<Fluid> DR_FLUIDS = DeferredRegister.create((ResourceKey)Registries.f_256808_, (String)"advanced_ae");
    public static final DeferredRegister<Block> DR_FLUID_BLOCKS = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"advanced_ae");
    public static final DeferredRegister<Item> DR_BUCKET_ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"advanced_ae");
    private static final List<FluidDefinition<?, ?>> FLUIDS = new ArrayList();
    public static final FluidDefinition<?, ?> QUANTUM_INFUSION = AAEFluids.fluid("Quantum Infusion", "quantum_infusion", QuantumInfusionFluidType::new, QuantumInfusionFluid.Flowing::new, QuantumInfusionFluid.Source::new, QuantumInfusionBlock::new);

    public static List<FluidDefinition<?, ?>> getFluids() {
        return Collections.unmodifiableList(FLUIDS);
    }

    private static <F extends Fluid, B extends LiquidBlock> FluidDefinition<F, B> fluid(String englishName, String id, Supplier<FluidType> fluidTypeSupplier, Supplier<F> flowingSupplier, Supplier<F> sourceSupplier, Supplier<B> liquidBlockSupplier) {
        RegistryObject type = DR_FLUID_TYPES.register(id + "_type", fluidTypeSupplier);
        RegistryObject flowing = DR_FLUIDS.register(id + "_flowing", flowingSupplier);
        RegistryObject source = DR_FLUIDS.register(id + "_source", sourceSupplier);
        RegistryObject block = DR_FLUID_BLOCKS.register(id + "_block", liquidBlockSupplier);
        RegistryObject bucketItem = DR_BUCKET_ITEMS.register(id + "_bucket", () -> new BucketItem((Supplier)source, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
        AAEItemDefinition<BucketItem> bucketDefinition = new AAEItemDefinition<BucketItem>(englishName + " Bucket", bucketItem);
        FluidDefinition definition = new FluidDefinition(englishName, (RegistryObject<FluidType>)type, flowing, source, block, bucketDefinition);
        FLUIDS.add(definition);
        return definition;
    }

    public static void init(IEventBus eventBus) {
        DR_FLUID_TYPES.register(eventBus);
        DR_FLUIDS.register(eventBus);
        DR_FLUID_BLOCKS.register(eventBus);
        DR_BUCKET_ITEMS.register(eventBus);
    }
}

