/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigInventory;
import appeng.util.ConfigMenuInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.api.ISetAmountMenuHost;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.SetAmountMenu;

public class QuantumArmorFilterConfigMenu
extends AEBaseMenu
implements ISubMenu,
ISetAmountMenuHost {
    @GuiSync(value=7)
    public UpgradeType upgradeType;
    public int slotIndex;
    private final ISubMenuHost host;
    protected final ConfigInventory inv;
    protected final FakeSlot[] slots = new FakeSlot[9];
    protected static final String OPEN_AMOUNT_MENU = "open_amount_menu";
    private boolean updatingFilters = false;

    public QuantumArmorFilterConfigMenu(MenuType<?> type, int id, Inventory playerInventory, ISubMenuHost host) {
        super(type, id, playerInventory, (Object)host);
        this.host = host;
        this.createPlayerInventorySlots(playerInventory);
        boolean filterQuantities = type == AAEMenus.QUANTUM_ARMOR_FILTER_CONFIG.get();
        this.inv = filterQuantities ? ConfigInventory.configStacks(this::typeFilter, (int)9, this::onSlotChanged, (boolean)true) : ConfigInventory.configTypes((int)9, this::onSlotChanged);
        ConfigMenuInventory wrappedInv = this.inv.createMenuWrapper();
        for (int x = 0; x < this.inv.size(); ++x) {
            this.slots[x] = new FakeSlot((InternalInventory)wrappedInv, x);
            this.addSlot((Slot)this.slots[x], SlotSemantics.CONFIG);
        }
        this.registerClientAction(OPEN_AMOUNT_MENU, Integer.class, this::openAmountMenu);
    }

    private boolean typeFilter(AEKey aeKey) {
        if (this.upgradeType == UpgradeType.AUTO_FEED) {
            if (aeKey instanceof AEItemKey) {
                AEItemKey key = (AEItemKey)aeKey;
                return key.toStack().getFoodProperties((LivingEntity)this.getPlayer()) != null;
            }
            return false;
        }
        return true;
    }

    public QuantumArmorFilterConfigMenu(int id, Inventory playerInventory, ISubMenuHost host) {
        this(AAEMenus.QUANTUM_ARMOR_FILTER_CONFIG.get(), id, playerInventory, host);
    }

    public ISubMenuHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuLocator locator, int slotIndex, List<GenericStack> filterList, UpgradeType upgradeType) {
        MenuOpener.open(AAEMenus.QUANTUM_ARMOR_FILTER_CONFIG.get(), (Player)player, (MenuLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorFilterConfigMenu) {
            QuantumArmorFilterConfigMenu cca = (QuantumArmorFilterConfigMenu)abstractContainerMenu;
            cca.setSlotIndex(slotIndex);
            cca.setUpgradeType(upgradeType);
            cca.setFilterList(filterList);
            cca.m_38946_();
        }
    }

    public void setSlotIndex(int index) {
        this.slotIndex = index;
    }

    public void setUpgradeType(UpgradeType upgradeType) {
        this.upgradeType = upgradeType;
    }

    public boolean isConfigSlot(Slot slot) {
        return this.getSlots(SlotSemantics.CONFIG).contains(slot);
    }

    public void setFilterList(List<GenericStack> filterList) {
        for (int x = 0; x < this.inv.size(); ++x) {
            AEKey aEKey;
            GenericStack filter;
            if (x < filterList.size() && (filter = filterList.get(x)) != null && (aEKey = filter.what()) instanceof AEItemKey) {
                AEItemKey key = (AEItemKey)aEKey;
                ItemStack stack = key.toStack();
                stack.m_41764_(Math.max(1, (int)filter.amount()));
                this.slots[x].m_5852_(stack);
                continue;
            }
            this.slots[x].m_5852_(ItemStack.f_41583_);
        }
    }

    public void onSlotChanged() {
        if (this.isClientSide() || this.updatingFilters) {
            return;
        }
        this.updateItemStack();
    }

    private void updateItemStack() {
        QuantumArmorBase item;
        this.updatingFilters = true;
        List<GenericStack> filterList = this.makeFilterList();
        ItemStack stack = this.getPlayer().m_150109_().m_8020_(this.slotIndex);
        Item item2 = stack.m_41720_();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)this.upgradeType) && item.hasUpgrade(stack, this.upgradeType)) {
            item.setFilter(stack, this.upgradeType, filterList);
        }
        this.updatingFilters = false;
    }

    protected List<GenericStack> makeFilterList() {
        ArrayList<GenericStack> filterList = new ArrayList<GenericStack>();
        for (int x = 0; x < this.inv.size(); ++x) {
            GenericStack stack = this.inv.getStack(x);
            if (stack == null) continue;
            filterList.add(stack);
        }
        return filterList;
    }

    public void openAmountMenu(int index) {
        MenuLocator locator;
        if (this.isClientSide()) {
            this.sendClientAction(OPEN_AMOUNT_MENU, index);
            return;
        }
        Slot slot = this.m_38853_(index);
        GenericStack currentStack = GenericStack.fromItemStack((ItemStack)slot.m_7993_());
        if (currentStack != null && (locator = this.getLocator()) != null && this.isServerSide()) {
            SetAmountMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), currentStack, newStack -> this.setFilter(slot.f_40219_, GenericStack.wrapInItemStack((GenericStack)newStack)), this, slot.m_6641_());
        }
    }

    @Override
    public void returnFromSetAmountMenu() {
        List<GenericStack> filterList = this.makeFilterList();
        Player player = this.getPlayerInventory().f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            QuantumArmorFilterConfigMenu.open(serverPlayer, this.getLocator(), this.slotIndex, filterList, this.upgradeType);
        }
    }
}

