/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.mixins;

import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.helpers.patternprovider.PatternProviderLogic;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.core.Direction;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogicHost;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public class MixinPatternProviderLogic {
    @Shadow
    IManagedGridNode mainNode;

    @Inject(method={"getActiveSides"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void onGetActiveSides(CallbackInfoReturnable<EnumSet<Direction>> cir, EnumSet<Direction> sides) {
        IGridNode node = this.mainNode.getNode();
        if (node != null) {
            for (Map.Entry entry : node.getInWorldConnections().entrySet()) {
                IGridNode otherNode = ((IGridConnection)entry.getValue()).getOtherSide(node);
                if (!(otherNode.getOwner() instanceof AdvPatternProviderLogicHost)) continue;
                sides.remove(entry.getKey());
            }
        }
        cir.setReturnValue(sides);
    }
}

