/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.CompassPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.EmptyLuaTable;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.StringUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomataBlockHandPlugin
extends AutomataCorePlugin {
    public AutomataBlockHandPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.DIG, SingleOperation.USE_ON_BLOCK};
    }

    @LuaFunction(mainThread=true)
    public final MethodResult digBlock(@NotNull IArguments arguments) throws LuaException {
        Optional optOptions = arguments.optTableUnsafe(0);
        EmptyLuaTable options = EmptyLuaTable.INSTANCE;
        if (optOptions.isPresent()) {
            options = (LuaTable)optOptions.get();
        }
        boolean sneak = options.optBoolean("sneak").orElse(false);
        float yaw = options.optDouble("yaw").orElse(0.0).floatValue();
        float pitch = options.optDouble("pitch").orElse(0.0).floatValue();
        return this.automataCore.withOperation(SingleOperation.DIG, context -> {
            TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
            ItemStack selectedTool = owner.getToolInMainHand();
            int previousDamageValue = selectedTool.m_41773_();
            Pair result = owner.withPlayer(APFakePlayer.wrapActionWithShiftKey(sneak, APFakePlayer.wrapActionWithRot(yaw, pitch, APFakePlayer::digBlock)));
            if (!((Boolean)result.getLeft()).booleanValue()) {
                return MethodResult.of((Object[])new Object[]{null, result.getRight()});
            }
            if (this.automataCore.hasAttribute("storingToolDurability")) {
                selectedTool.m_41721_(previousDamageValue);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult useOnBlock(@NotNull IArguments arguments) throws LuaException {
        Optional optOptions = arguments.optTableUnsafe(0);
        EmptyLuaTable options = EmptyLuaTable.INSTANCE;
        if (optOptions.isPresent()) {
            options = (LuaTable)optOptions.get();
        }
        boolean sneak = options.optBoolean("sneak").orElse(false);
        float yaw = options.optDouble("yaw").orElse(0.0).floatValue();
        float pitch = options.optDouble("pitch").orElse(0.0).floatValue();
        return this.automataCore.withOperation(SingleOperation.USE_ON_BLOCK, context -> {
            TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
            ItemStack selectedTool = owner.getToolInMainHand();
            int previousDamageValue = selectedTool.m_41773_();
            InteractionResult result = owner.withPlayer(APFakePlayer.wrapActionWithShiftKey(sneak, APFakePlayer.wrapActionWithRot(yaw, pitch, APFakePlayer::useOnBlock)));
            if (this.automataCore.hasAttribute("storingToolDurability")) {
                selectedTool.m_41721_(previousDamageValue);
            }
            return MethodResult.of((Object[])new Object[]{result.m_19077_(), result.toString()});
        });
    }

    @LuaFunction(mainThread=true)
    public MethodResult placeBlock(@NotNull IArguments arguments) throws LuaException {
        Optional optOptions = arguments.optTableUnsafe(0);
        LuaTable options = optOptions.orElse(EmptyLuaTable.INSTANCE);
        ITurtleAccess turtle = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getTurtle();
        CompassPeripheral compassPeripheral = Stream.of(TurtleSide.values()).map(side -> {
            CompassPeripheral compass;
            IPeripheral patt6962$temp = turtle.getPeripheral(side);
            return patt6962$temp instanceof CompassPeripheral ? (compass = (CompassPeripheral)patt6962$temp) : null;
        }).filter(peripheral -> peripheral != null).findFirst().orElse(null);
        if (compassPeripheral == null || !compassPeripheral.isEnabled()) {
            return MethodResult.of((Object[])new Object[]{false, "COMPASS_NOT_EQUIPPED"});
        }
        int x = options.optInt("x").orElse(0);
        int y = options.optInt("y").orElse(0);
        int z = options.optInt("z").orElse(0);
        int maxDist = (Integer)APConfig.PERIPHERALS_CONFIG.compassAccurePlaceRadius.get();
        int freeDist = (Integer)APConfig.PERIPHERALS_CONFIG.compassAccurePlaceFreeRadius.get();
        if (Math.abs(x) > maxDist || Math.abs(y) > maxDist || Math.abs(z) > maxDist) {
            return MethodResult.of((Object[])new Object[]{null, "OUT_OF_RANGE"});
        }
        String anchor = options.optString("anchor").orElse(null);
        String front = options.optString("front").orElse(null);
        String top = options.optString("top").orElse(null);
        Direction anchorDir = anchor != null ? this.automataCore.validateSide(anchor) : null;
        Direction frontDir = front != null ? this.automataCore.validateSide(front) : null;
        Direction topDir = top != null ? this.automataCore.validateSide(top) : null;
        int distance = Math.max(0, Math.abs(x) - freeDist) + Math.max(0, Math.abs(y) - freeDist) + Math.max(0, Math.abs(z) - freeDist);
        return this.automataCore.withOperation(SingleOperation.ACCURE_PLACE, new SingleOperationContext(1, distance), context -> {
            ItemStack stack = turtle.getInventory().m_8020_(turtle.getSelectedSlot());
            if (stack.m_41619_()) {
                return MethodResult.of((Object[])new Object[]{null, "EMPTY_SLOT"});
            }
            BlockPos position = turtle.getPosition().m_7918_(x, y, z);
            String err = this.deployOn(stack, position, anchorDir, frontDir, topDir, options);
            if (err != null) {
                return MethodResult.of((Object[])new Object[]{null, err});
            }
            return MethodResult.of((Object)true);
        }, null);
    }

    @Nullable
    private String deployOn(ItemStack stack, BlockPos position, Direction anchor, Direction front, Direction top, LuaTable<?, ?> options) throws LuaException {
        BlockEntity blockEntity;
        ITurtleAccess turtle = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getTurtle();
        Level world = turtle.getLevel();
        if (anchor == null) {
            anchor = turtle.getDirection();
        }
        if (front == null) {
            front = anchor;
        }
        if (top == null) {
            top = Direction.UP;
        }
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition((ITurtleAccess)turtle, (BlockPos)position, (Direction)front.m_122424_());
        BlockHitResult hit = BlockHitResult.m_82426_((Vec3)Vec3.m_82512_((Vec3i)position), (Direction)top, (BlockPos)position);
        AdvanceDirectionalPlaceContext context = new AdvanceDirectionalPlaceContext(world, position, anchor, front, stack, top);
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)turtlePlayer.player(), (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)position, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return "EVENT_CANCELED";
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return "NOT_BLOCK";
        }
        BlockItem block = (BlockItem)item;
        InteractionResult res = block.m_40576_((BlockPlaceContext)context);
        if (!res.m_19077_()) {
            return "CANNOT_PLACE";
        }
        if (block instanceof SignItem && (blockEntity = world.m_7702_(position)) instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            String text = StringUtil.convertAndToSectionMark(options.optString("text").orElse(null));
            AutomataBlockHandPlugin.setSignText(world, sign, text, true);
            String backText = StringUtil.convertAndToSectionMark(options.optString("backText").orElse(null));
            AutomataBlockHandPlugin.setSignText(world, sign, backText, false);
        }
        return null;
    }

    private static void setSignText(Level world, SignBlockEntity block, String text, boolean front) {
        SignText sign = block.m_277157_(front);
        if (text == null) {
            for (int i = 0; i < 4; ++i) {
                sign.m_276913_(i, (Component)Component.m_237113_((String)""));
            }
        } else {
            String[] lines = text.split("\n");
            for (int i = 0; i < 4; ++i) {
                sign.m_276913_(i, (Component)Component.m_237113_((String)(i < lines.length ? lines[i] : "")));
            }
        }
        block.m_6596_();
        world.m_7260_(block.m_58899_(), block.m_58900_(), block.m_58900_(), 3);
    }

    private static class AdvanceDirectionalPlaceContext
    extends DirectionalPlaceContext {
        private final Direction anchor;

        AdvanceDirectionalPlaceContext(Level world, BlockPos pos, Direction anchor, Direction front, ItemStack stack, Direction top) {
            super(world, pos, front, stack, top);
            this.anchor = anchor;
        }

        public Direction m_7820_() {
            return this.anchor;
        }

        public Direction[] m_6232_() {
            Direction[] directionArray;
            switch (this.anchor) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DOWN: {
                    Direction[] directionArray2 = new Direction[6];
                    directionArray2[0] = Direction.DOWN;
                    directionArray2[1] = Direction.NORTH;
                    directionArray2[2] = Direction.EAST;
                    directionArray2[3] = Direction.SOUTH;
                    directionArray2[4] = Direction.WEST;
                    directionArray = directionArray2;
                    directionArray2[5] = Direction.UP;
                    break;
                }
                case UP: {
                    Direction[] directionArray3 = new Direction[6];
                    directionArray3[0] = Direction.UP;
                    directionArray3[1] = Direction.NORTH;
                    directionArray3[2] = Direction.EAST;
                    directionArray3[3] = Direction.SOUTH;
                    directionArray3[4] = Direction.WEST;
                    directionArray = directionArray3;
                    directionArray3[5] = Direction.DOWN;
                    break;
                }
                case NORTH: {
                    Direction[] directionArray4 = new Direction[6];
                    directionArray4[0] = Direction.NORTH;
                    directionArray4[1] = Direction.EAST;
                    directionArray4[2] = Direction.WEST;
                    directionArray4[3] = Direction.UP;
                    directionArray4[4] = Direction.DOWN;
                    directionArray = directionArray4;
                    directionArray4[5] = Direction.SOUTH;
                    break;
                }
                case SOUTH: {
                    Direction[] directionArray5 = new Direction[6];
                    directionArray5[0] = Direction.SOUTH;
                    directionArray5[1] = Direction.EAST;
                    directionArray5[2] = Direction.WEST;
                    directionArray5[3] = Direction.UP;
                    directionArray5[4] = Direction.DOWN;
                    directionArray = directionArray5;
                    directionArray5[5] = Direction.NORTH;
                    break;
                }
                case WEST: {
                    Direction[] directionArray6 = new Direction[6];
                    directionArray6[0] = Direction.WEST;
                    directionArray6[1] = Direction.SOUTH;
                    directionArray6[2] = Direction.UP;
                    directionArray6[3] = Direction.NORTH;
                    directionArray6[4] = Direction.DOWN;
                    directionArray = directionArray6;
                    directionArray6[5] = Direction.EAST;
                    break;
                }
                case EAST: {
                    Direction[] directionArray7 = new Direction[6];
                    directionArray7[0] = Direction.EAST;
                    directionArray7[1] = Direction.SOUTH;
                    directionArray7[2] = Direction.UP;
                    directionArray7[3] = Direction.NORTH;
                    directionArray7[4] = Direction.DOWN;
                    directionArray = directionArray7;
                    directionArray7[5] = Direction.WEST;
                }
            }
            return directionArray;
        }
    }
}

