/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.silo;

import ballistix.api.silo.ILauncherControlPanel;
import ballistix.registers.BallistixCapabilities;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SiloRegistry {
    public static void registerSilo(int frequency, ILauncherControlPanel silo) {
        ServerLifecycleHooks.getCurrentServer().m_129783_().getCapability(BallistixCapabilities.SILO_REGISTRY).ifPresent(cap -> cap.addSilo(frequency, silo.getPos()));
    }

    public static void unregisterSilo(int frequency, ILauncherControlPanel silo) {
        ServerLifecycleHooks.getCurrentServer().m_129783_().getCapability(BallistixCapabilities.SILO_REGISTRY).ifPresent(cap -> cap.removeSilo(frequency, silo.getPos()));
    }

    public static HashSet<ILauncherControlPanel> getSilos(int freq, Level world) {
        return ServerLifecycleHooks.getCurrentServer().m_129783_().getCapability(BallistixCapabilities.SILO_REGISTRY).map(cap -> {
            HashSet<ILauncherControlPanel> silos = new HashSet<ILauncherControlPanel>();
            for (BlockPos pos : cap.getSilosForFrequency(freq)) {
                BlockEntity tile = world.m_7702_(pos);
                if (tile == null || !(tile instanceof ILauncherControlPanel)) continue;
                ILauncherControlPanel silo = (ILauncherControlPanel)tile;
                silos.add(silo);
            }
            return silos;
        }).orElse(new HashSet());
    }
}

