/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.particle;

import ballistix.client.particle.ParticleBlastSmoke;
import ballistix.client.particle.ParticleOptionsMissileSmoke;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import voltaic.Voltaic;

public class ParticleMissileSmoke
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private boolean burning;
    private double friction = 0.96f;
    private float startRed = 1.0f;
    private float startGreen = 0.7f;
    private float startBlue = 0.2f;
    private float endRed = 0.7f;
    private float endGreen = 0.1f;
    private float endBlue = 0.1f;
    private float endGray = 0.5f;
    private float startQuadSize;

    public ParticleMissileSmoke(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleOptionsMissileSmoke options, SpriteSet set) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107226_ = 0.0f;
        this.f_172259_ = true;
        this.sprites = set;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107227_ = options.r;
        this.f_107228_ = options.g;
        this.f_107229_ = options.b;
        this.f_107663_ = options.scale;
        this.startQuadSize = options.scale;
        this.f_107225_ = (int)((double)options.lifetime * (0.8 + Voltaic.RANDOM.nextDouble() * 0.2));
        this.m_108339_(this.sprites);
        this.f_107219_ = options.hasPhysics;
        double brightnessRandom = 0.2 * Voltaic.RANDOM.nextDouble();
        this.startRed = (float)((double)this.startRed * (0.8 + brightnessRandom));
        this.startGreen = (float)((double)this.startGreen * (0.8 + brightnessRandom));
        this.startBlue = (float)((double)this.startBlue * (0.8 + brightnessRandom));
        this.endRed = (float)((double)this.endRed * (0.8 + brightnessRandom));
        this.endGreen = (float)((double)this.endGreen * (0.8 + brightnessRandom));
        this.endBlue = (float)((double)this.endBlue * (0.8 + brightnessRandom));
        this.f_107227_ = (float)((double)this.f_107227_ * (0.4 + brightnessRandom));
        this.f_107228_ = (float)((double)this.f_107228_ * (0.4 + brightnessRandom));
        this.f_107229_ = (float)((double)this.f_107229_ * (0.4 + brightnessRandom));
        this.endGray = (float)((double)this.endGray * (0.8 + brightnessRandom));
        this.m_107253_(this.startRed, this.startGreen, this.startBlue);
        this.f_107226_ = (float)((double)this.f_107226_ * (this.burning ? 0.75 + Voltaic.RANDOM.nextDouble() * 0.5 : 1.5 * Voltaic.RANDOM.nextDouble()));
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107215_ *= this.friction;
        this.f_107216_ *= this.friction;
        this.f_107217_ *= this.friction;
        super.m_5989_();
        this.m_108339_(this.sprites);
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        super.m_5744_(buffer, renderInfo, partialTicks);
        float lifeProgress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        if (lifeProgress <= 1.0f && lifeProgress >= 0.0f) {
            int burningTime = this.f_107225_ / 3;
            int orangeTime = (int)((double)burningTime / 1.3);
            this.f_107227_ = ParticleBlastSmoke.smoothTransition((float)this.f_107224_ + partialTicks, this.startRed, this.endRed, this.endGray, orangeTime, burningTime - orangeTime);
            this.f_107228_ = ParticleBlastSmoke.smoothTransition((float)this.f_107224_ + partialTicks, this.startGreen, this.endGreen, this.endGray, orangeTime, burningTime - orangeTime);
            this.f_107229_ = ParticleBlastSmoke.smoothTransition((float)this.f_107224_ + partialTicks, this.startBlue, this.endBlue, this.endGray, orangeTime, burningTime - orangeTime);
            this.f_107663_ = this.startQuadSize * Mth.m_14089_((float)((float)(1.5707963705062866 * Math.pow(1.0f - lifeProgress - 1.0f, 5.0))));
        }
    }

    public static class Factory
    implements ParticleProvider<ParticleOptionsMissileSmoke>,
    ParticleEngine.SpriteParticleRegistration<ParticleOptionsMissileSmoke> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ParticleOptionsMissileSmoke type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleMissileSmoke(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }

        public ParticleProvider<ParticleOptionsMissileSmoke> m_107419_(SpriteSet sprites) {
            return new Factory(sprites);
        }
    }
}

