/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.shake;

import ballistix.client.shake.CameraShakeEffect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="ballistix", value={Dist.CLIENT})
public class CameraShakeManager {
    private static final List<CameraShakeEffect> activeShakes = new ArrayList<CameraShakeEffect>();

    private CameraShakeManager() {
    }

    public static void addShake(CameraShakeEffect effect) {
        activeShakes.add(effect);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.m_91104_()) {
            return;
        }
        long currentTime = mc.f_91073_.m_46467_();
        float totalYawOffset = 0.0f;
        float totalPitchOffset = 0.0f;
        Iterator<CameraShakeEffect> iterator = activeShakes.iterator();
        while (iterator.hasNext()) {
            CameraShakeEffect effect = iterator.next();
            if (effect.isComplete(currentTime)) {
                iterator.remove();
                continue;
            }
            float[] offsets = effect.getShakeOffsets(currentTime);
            totalYawOffset += offsets[0];
            totalPitchOffset += offsets[1];
        }
        if (mc.f_91074_.m_20096_()) {
            mc.f_91074_.m_146922_(mc.f_91074_.m_146908_() + totalYawOffset);
            mc.f_91074_.m_146926_(mc.f_91074_.m_146909_() + totalPitchOffset);
        }
    }

    public static CameraShakeEffect createBlastSourcedEffect(double blastDuration, double blastSize, long worldTime, Vec3 position) {
        double dist = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(position);
        double damp = Math.exp(-2.0 * dist / blastSize);
        double amplitude = blastSize / 3.0 * damp;
        long seed = (long)(position.f_82479_ + position.f_82480_ * 26.0 + position.f_82481_ * 36.0);
        CameraShakeEffect effect = new CameraShakeEffect(blastDuration, blastDuration / 4.0, blastDuration / 4.0, amplitude, 40.0, worldTime, seed);
        return effect;
    }
}

