/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.util.thread.raycast;

import ballistix.common.blast.util.thread.raycast.DynamicRay;
import ballistix.common.blast.util.thread.raycast.IResistanceCallback;
import ballistix.common.blast.util.thread.raycast.ThreadDynamicRaycastBlast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ThreadDynamicRaySideBlast
extends Thread {
    public final ThreadDynamicRaycastBlast mainBlast;
    public final Direction direction;
    private final RandomSource random = RandomSource.m_216337_();
    private ArrayList<DynamicRay> rays = new ArrayList();
    private static final float DEFAULT_POWER_DEC = 1.125f;

    public ThreadDynamicRaySideBlast(ThreadDynamicRaycastBlast threadRaycastBlast, Direction dir) {
        this.mainBlast = threadRaycastBlast;
        this.direction = dir;
        this.setName("Raycast Blast Side Thread");
        this.setPriority(10);
        this.initializeRays();
    }

    private void initializeRays() {
        int explosionRadius = this.mainBlast.explosionRadius;
        BlockPos position = this.mainBlast.position;
        int iMin = -explosionRadius;
        int iMax = explosionRadius;
        int jMax = explosionRadius;
        int jMin = -explosionRadius;
        Vec3i orientation = this.direction.m_122436_();
        float explosionEnergy = this.mainBlast.explosionEnergy;
        boolean xNotZero = orientation.m_123341_() != 0;
        boolean yNotZero = orientation.m_123342_() != 0;
        boolean zNotZero = orientation.m_123343_() != 0;
        int expX = orientation.m_123341_() * explosionRadius;
        int expY = orientation.m_123342_() * explosionRadius;
        int expZ = orientation.m_123343_() * explosionRadius;
        for (int i = iMin; i < iMax; ++i) {
            for (int j = jMin; j < jMax; ++j) {
                int x = 0;
                int y = 0;
                int z = 0;
                if (xNotZero) {
                    x = expX;
                    y += i;
                    z += j;
                } else if (yNotZero) {
                    x += i;
                    y = expY;
                    z += j;
                } else if (zNotZero) {
                    x += i;
                    y += j;
                    z = expZ;
                }
                float power = explosionEnergy - explosionEnergy * this.random.m_188501_() / 2.0f;
                BlockPos currentBlockPos = new BlockPos((Vec3i)position);
                float currentX = (float)position.m_123341_() + 0.5f;
                float currentY = (float)position.m_123342_() + 0.5f;
                float currentZ = (float)position.m_123343_() + 0.5f;
                float len = Mth.m_14116_((float)(x * x + y * y + z * z));
                float invLen = len == 0.0f ? 0.0f : 1.0f / len;
                float dx = (float)x * invLen;
                float dy = (float)y * invLen;
                float dz = (float)z * invLen;
                this.rays.add(new DynamicRay(currentX, currentY, currentZ, dx, dy, dz, power, currentBlockPos, 1.125f, this.mainBlast));
            }
        }
    }

    @Override
    public void run() {
        Level world = this.mainBlast.level;
        IResistanceCallback callback = this.mainBlast.callBack;
        Entity explosionSource = this.mainBlast.explosionSource;
        BlockPos position = this.mainBlast.position;
        while (!this.rays.isEmpty()) {
            Iterator<DynamicRay> it = this.rays.iterator();
            HashMap<BlockPos, BlockState> positions = new HashMap<BlockPos, BlockState>();
            while (it.hasNext()) {
                DynamicRay ray = it.next();
                if (!ray.tick(position, world, callback, explosionSource, positions)) continue;
                it.remove();
            }
        }
        this.mainBlast.underBlasts.remove(this);
    }
}

