/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.packet.type.client;

import ballistix.api.radar.IDetected;
import ballistix.common.packet.type.client.ClientBarrierMethods;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;

public class PacketSetSearchRadarTrackedClient {
    public static final StreamCodec<FriendlyByteBuf, PacketSetSearchRadarTrackedClient> CODEC = new StreamCodec<FriendlyByteBuf, PacketSetSearchRadarTrackedClient>(){
        private static final StreamCodec<ByteBuf, Vec3> VEC_3_STREAM_CODEC = new StreamCodec<ByteBuf, Vec3>(){

            public Vec3 decode(ByteBuf buffer) {
                return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }

            public void encode(ByteBuf buffer, Vec3 value) {
                buffer.writeDouble(value.f_82479_);
                buffer.writeDouble(value.f_82480_);
                buffer.writeDouble(value.f_82481_);
            }
        };

        public PacketSetSearchRadarTrackedClient decode(FriendlyByteBuf buf) {
            HashSet<IDetected.Detected> detected = new HashSet<IDetected.Detected>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                detected.add(new IDetected.Detected((Vec3)VEC_3_STREAM_CODEC.decode((Object)buf), ((ItemStack)StreamCodec.ITEM_STACK.decode((Object)buf)).m_41720_(), buf.readBoolean()));
            }
            return new PacketSetSearchRadarTrackedClient(detected, (BlockPos)StreamCodec.BLOCK_POS.decode((Object)buf));
        }

        public void encode(FriendlyByteBuf buf, PacketSetSearchRadarTrackedClient packet) {
            buf.writeInt(packet.detected.size());
            for (IDetected.Detected detected : packet.detected) {
                VEC_3_STREAM_CODEC.encode((Object)buf, (Object)detected.getPosition());
                StreamCodec.ITEM_STACK.encode((Object)buf, (Object)new ItemStack((ItemLike)detected.getItem()));
                buf.writeBoolean(detected.showBearing());
            }
            StreamCodec.BLOCK_POS.encode((Object)buf, (Object)packet.tilePos);
        }
    };
    private final HashSet<IDetected.Detected> detected;
    private final BlockPos tilePos;

    public PacketSetSearchRadarTrackedClient(HashSet<IDetected.Detected> detected, BlockPos tilePos) {
        this.detected = detected;
        this.tilePos = tilePos;
    }

    public static void handle(PacketSetSearchRadarTrackedClient message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handleSetSearchRadarTrackedClient(message.detected, message.tilePos));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetSearchRadarTrackedClient pkt, FriendlyByteBuf buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketSetSearchRadarTrackedClient decode(FriendlyByteBuf buf) {
        return (PacketSetSearchRadarTrackedClient)CODEC.decode((Object)buf);
    }
}

