/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.silo;

import ballistix.api.blast.IBlast;
import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.api.missile.virtual.VirtualProjectile;
import ballistix.api.silo.ILauncherControlPanel;
import ballistix.api.silo.ILauncherPlatform;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBallistixMachine;
import ballistix.common.block.subtype.SubtypeMissile;
import ballistix.common.inventory.container.ContainerLauncherPlatformT1;
import ballistix.common.inventory.container.ContainerLauncherPlatformT2;
import ballistix.common.inventory.container.ContainerLauncherPlatformT3;
import ballistix.common.item.ItemMissile;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.TileESMTower;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.common.tile.radar.TileSearchRadar;
import ballistix.common.tile.turret.antimissile.util.TileTurretAntimissile;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentTile;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileLauncherPlatformT1
extends GenericTile
implements ILauncherPlatform,
IMultiblockParentTile {
    public static final int MISSILE_SLOT = 0;
    public static final int EXPLOSIVE_SLOT = 1;
    public static final int COOLDOWN = 100;
    public SingleProperty<Boolean> hasExplosive = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasexplosive", (Object)false));
    public SingleProperty<Boolean> hasMissile = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasmissile", (Object)false));
    public SingleProperty<Boolean> hasSam = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hassam", (Object)false));

    public TileLauncherPlatformT1(BlockPos pos, BlockState state) {
        this((BlockEntityType)BallistixTiles.TILE_LAUNCHER_PLATFORM_TIER1.get(), pos, state);
    }

    public TileLauncherPlatformT1(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        int tier = this.getTier();
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(2)).setDirectionsBySlot(Integer.valueOf(0), BlockEntityUtils.MachineDirection.values()).setDirectionsBySlot(Integer.valueOf(1), BlockEntityUtils.MachineDirection.values()).valid(this::isItemValidForSlot));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        if (tier == 1) {
            this.addComponent((IComponent)new ComponentContainerProvider("launcherplatformtier" + tier, (GenericTile)this).createMenu((id, player) -> new ContainerLauncherPlatformT1((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        } else if (tier == 2) {
            this.addComponent((IComponent)new ComponentContainerProvider("launcherplatformtier" + tier, (GenericTile)this).createMenu((id, player) -> new ContainerLauncherPlatformT2((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        } else if (tier == 3) {
            this.addComponent((IComponent)new ComponentContainerProvider("launcherplatformtier" + tier, (GenericTile)this).createMenu((id, player) -> new ContainerLauncherPlatformT3((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        }
    }

    @Override
    public int getRange() {
        return BallistixConstants.LAUNCHER_PLATFORM_RANGE_T1;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public int launch(ILauncherControlPanel controlPanel, boolean redstoneTriggered, int inaccuracy) {
        int cooldown = 0;
        if (redstoneTriggered && ((Boolean)this.hasSam.getValue()).booleanValue()) {
            ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
            BlockPos target = controlPanel.getTarget();
            BlockEntity blockEntity = this.f_58857_.m_7702_(target);
            if (blockEntity instanceof TileFireControlRadar) {
                TileFireControlRadar radar = (TileFireControlRadar)blockEntity;
                if (TileTurretAntimissile.getDistanceToPos(this.m_58899_(), radar.m_58899_()) < BallistixConstants.MAX_DISTANCE_FROM_RADAR && radar.tracking != null) {
                    Vec3 vec3 = new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
                    if (TileFireControlRadar.getDistanceToMissile(vec3, radar.tracking.position) > 100.0) {
                        VirtualProjectile.VirtualSAM sam = new VirtualProjectile.VirtualSAM(0.0f, new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5), new Vec3(0.0, 1.0, 0.0), (float)BallistixConstants.FIRE_CONTROL_RADAR_RANGE * 3.0f, target, 1);
                        MissileManager.addSAM((ResourceKey<Level>)this.f_58857_.m_46472_(), sam);
                        inv.m_7407_(0, 1);
                        cooldown = 200;
                    }
                }
            }
        } else if (!((Boolean)this.hasSam.getValue()).booleanValue()) {
            BlockEntity target = this.f_58857_.m_7702_(controlPanel.getTarget());
            if (target instanceof TileSearchRadar) {
                TileSearchRadar radar = (TileSearchRadar)target;
                if (TileTurretAntimissile.getDistanceToPos(this.m_58899_(), radar.m_58899_()) <= BallistixConstants.MAX_DISTANCE_FROM_RADAR && redstoneTriggered && !radar.trackedEsmTowers.isEmpty()) {
                    for (TileESMTower tower : radar.trackedEsmTowers) {
                        if (tower == null || tower.m_58901_() || !this.launchMissile(tower.m_58899_(), controlPanel.getFrequency())) continue;
                        cooldown = 500;
                        break;
                    }
                }
            } else {
                double length = (double)inaccuracy * this.f_58857_.f_46441_.m_188500_();
                double angle = this.f_58857_.f_46441_.m_188500_() * 2.0 * Math.PI;
                int offsetX = (int)(length * Math.cos(angle));
                int offsetZ = (int)(length * Math.sin(angle));
                BlockPos pos = controlPanel.getTarget().m_7918_(offsetX, 0, offsetZ);
                if (this.launchMissile(pos, controlPanel.getFrequency())) {
                    cooldown = 100;
                }
            }
        }
        if (cooldown > 0) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)BallistixSounds.SOUND_MISSILE_SILO.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return cooldown;
    }

    public boolean launchMissile(BlockPos target, int frequency) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack mis = inv.m_8020_(0);
        ItemStack explosive = inv.m_8020_(1);
        boolean isCluster = false;
        Item item = mis.m_41720_();
        if (item instanceof ItemMissile) {
            ItemMissile itmissile = (ItemMissile)item;
            if (Blast.ITEM_TO_BLAST_MAP.get(explosive.m_41720_()) != null) {
                IBlast blast = Blast.ITEM_TO_BLAST_MAP.get(explosive.m_41720_());
                if (blast.tier() > itmissile.missile.tier() || itmissile.missile.tier() > this.getTier() || blast.tier() > this.getTier()) {
                    return false;
                }
                boolean bl = isCluster = itmissile.missile == SubtypeMissile.cluster;
                if (isCluster && inv.m_8020_(1).m_41613_() < 5) {
                    return false;
                }
                VirtualMissile missile = new VirtualMissile(new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5), new Vec3(0.0, 1.0, 0.0), 0.0f, isCluster ? VirtualMissile.FlightPath.SILO_CLUSTER : VirtualMissile.FlightPath.SILO, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123343_() + 0.5f, target, itmissile.missile.ordinal() + 1, blast, frequency, this.getTier() > 1);
                MissileManager.addMissile((ResourceKey<Level>)this.f_58857_.m_46472_(), missile);
                inv.m_7407_(0, 1);
                inv.m_7407_(1, isCluster ? 5 : 1);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isItemValidForSlot(int index, ItemStack stack, ComponentInventory inv) {
        Item item = stack.m_41720_();
        if (index == 0) {
            if (item instanceof ItemMissile) {
                ItemMissile missile = (ItemMissile)item;
                if (missile.missile.tier() <= this.getTier()) return true;
            }
            if (stack.m_41720_() != BallistixItems.ITEM_AAMISSILEMK2.get()) return false;
            return true;
        }
        if (index != 1) return false;
        IBlast blast = Blast.ITEM_TO_BLAST_MAP.get(item);
        if (blast == null) return false;
        if (blast.tier() > this.getTier()) return false;
        if (blast.tier() <= -1) return false;
        return true;
    }

    public void onInventoryChange(ComponentInventory inv, int index) {
        this.handleMissile(inv, index);
        this.handleExplosive(inv, index);
    }

    private void handleMissile(ComponentInventory inv, int index) {
        if (index == 0 || index == -1) {
            boolean sam;
            ItemStack missile = inv.m_8020_(0);
            if (missile.m_41619_()) {
                this.hasMissile.setValue((Object)false);
                this.hasSam.setValue((Object)false);
                return;
            }
            boolean bl = sam = missile.m_41720_() == BallistixItems.ITEM_AAMISSILEMK2.get();
            if (missile.m_41720_() instanceof ItemMissile || sam) {
                this.hasMissile.setValue((Object)true);
                this.hasSam.setValue((Object)sam);
            } else {
                this.hasMissile.setValue((Object)false);
                this.hasSam.setValue((Object)false);
            }
        }
    }

    private void handleExplosive(ComponentInventory inv, int index) {
        if (index == 1 || index == -1) {
            ItemStack explosive = inv.m_8020_(1);
            if (!explosive.m_41619_() && Blast.ITEM_TO_BLAST_MAP.get(explosive.m_41720_()) != null || explosive.m_41619_() && inv.m_8020_(0).m_150930_((Item)BallistixItems.ITEM_AAMISSILEMK2.get())) {
                this.hasExplosive.setValue((Object)true);
            } else {
                this.hasExplosive.setValue((Object)false);
            }
        }
    }

    @Override
    public boolean hasExplosive() {
        return (Boolean)this.hasExplosive.getValue();
    }

    @Override
    public boolean hasMissile() {
        return (Boolean)this.hasMissile.getValue();
    }

    @Override
    public boolean hasSAM() {
        return (Boolean)this.hasSam.getValue();
    }

    public IMultiblockParentBlock.SubnodeWrapper getSubNodes() {
        return SubtypeBallistixMachine.Subnodes.LAUNCHER_PLATFORM_TIER1;
    }

    public void onSubnodeDestroyed(TileMultiSubnode tileMultiSubnode) {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public InteractionResult onSubnodeUse(Player player, InteractionHand hand, BlockHitResult hit, TileMultiSubnode subnode) {
        return this.use(player, hand, hit);
    }

    @NotNull
    public <T> LazyOptional<T> getSubnodeCapability(@NotNull Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    public Direction getFacingDirection() {
        return this.getFacing();
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(10.0);
    }
}

