/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import umpaz.brewinandchewin.common.capability.RagingCapability;
import umpaz.brewinandchewin.common.capability.TipsyNumbedHeartsCapability;
import umpaz.brewinandchewin.common.network.BnCNetworkHandler;
import umpaz.brewinandchewin.common.network.clientbound.ClearKegFluidContainerComponentsPacket;
import umpaz.brewinandchewin.common.registry.BnCDamageTypes;
import umpaz.brewinandchewin.common.registry.BnCEffects;
import umpaz.brewinandchewin.common.tag.BnCTags;

@Mod.EventBusSubscriber(modid="brewinandchewin", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BnCCommonEvents {
    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            event.addCapability(TipsyNumbedHeartsCapability.ID, (ICapabilityProvider)new TipsyNumbedHeartsCapability(living));
            event.addCapability(RagingCapability.ID, (ICapabilityProvider)new RagingCapability());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinLevel(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(TipsyNumbedHeartsCapability.INSTANCE).ifPresent(cap -> cap.syncToPlayer(serverPlayer));
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                living.getCapability(TipsyNumbedHeartsCapability.INSTANCE).ifPresent(cap -> cap.syncToPlayer(serverPlayer));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getEntity().getCapability(TipsyNumbedHeartsCapability.INSTANCE).ifPresent(cap -> {
                cap.setFrom((TipsyNumbedHeartsCapability)event.getOriginal().getCapability(TipsyNumbedHeartsCapability.INSTANCE).orElse(null));
                cap.sync();
            });
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TipsyNumbedHeartsCapability.INSTANCE).ifPresent(cap -> {
            if ((double)cap.getNumbedHealth() > 0.0) {
                if (cap.getTicksUntilDamage() > 0) {
                    cap.setTicksUntilDamage(cap.getTicksUntilDamage() - 1);
                }
                if (!(cap.getTicksUntilDamage() > 0 && living.m_21023_((MobEffect)BnCEffects.TIPSY.get()) || living.m_9236_().f_46443_)) {
                    float health = living.m_21223_() + living.m_6103_();
                    int remainingHealth = Mth.m_14167_((float)Math.min(cap.getNumbedHealth() - (float)(health % 1.0f > cap.getNumbedHealth() % 1.0f ? 1 : 0), health));
                    if (remainingHealth > 0) {
                        living.m_6469_(living.m_269291_().m_269079_(BnCDamageTypes.CARDIAC_ARREST), cap.getNumbedHealth());
                    }
                    cap.setNumbedHealth(0.0f);
                    cap.sync();
                }
            }
        });
        RagingCapability.tick(living);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        if (!target.m_21023_((MobEffect)BnCEffects.TIPSY.get()) || event.getSource().m_276093_(BnCDamageTypes.CARDIAC_ARREST)) {
            return;
        }
        int amplifier = target.m_21124_((MobEffect)BnCEffects.TIPSY.get()).m_19564_();
        float maximumNumbedHealth = Mth.m_14036_((float)(Mth.m_14143_((float)((2.0f + (float)amplifier * 1.6f) / 2.0f)) * 2), (float)1.0f, (float)(target.m_21233_() - 2.0f));
        target.getCapability(TipsyNumbedHeartsCapability.INSTANCE).ifPresent(cap -> {
            float numbedHealth = Math.min(cap.getNumbedHealth() + event.getAmount(), maximumNumbedHealth);
            if (numbedHealth - cap.getNumbedHealth() <= target.m_21223_()) {
                event.setAmount(event.getAmount() - (numbedHealth - cap.getNumbedHealth()));
            }
            cap.setNumbedHealth(numbedHealth);
            cap.setTicksUntilDamage(200 + 20 * amplifier);
            if (target instanceof Player) {
                cap.sync();
            }
        });
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        LivingEntity living;
        Entity attacker = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (attacker instanceof LivingEntity && (!((living = (LivingEntity)attacker) instanceof Player) || (player = (Player)living).m_36403_(0.0f) > 0.8f) && living.m_21023_((MobEffect)BnCEffects.RAGING.get()) && event.getSource().m_269533_(BnCTags.TRIGGERS_RAGING)) {
            living.getCapability(RagingCapability.INSTANCE).ifPresent(cap -> {
                float f;
                int stacks = Math.min(4, cap.getStacks() + 1);
                if (stacks != cap.getStacks() && !target.m_9236_().m_5776_()) {
                    double heightAddition = living.m_20227_(1.0) - living.m_20227_(0.5);
                    ((ServerLevel)target.m_9236_()).m_8767_(RagingCapability.getParticleType(stacks, 0.5f), target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 12, target.m_217043_().m_188500_() * 0.4 - 0.2, target.m_217043_().m_188500_() * heightAddition * 2.0 - heightAddition, target.m_217043_().m_188500_() * 0.4 - 0.2, 0.0);
                }
                cap.setStacks(stacks);
                if (living instanceof Player) {
                    Player player = (Player)living;
                    f = player.m_36333_();
                } else {
                    f = 30.0f;
                }
                cap.setTicksUntilReset(Mth.m_14167_((float)(2.5f * f)));
            });
        }
    }

    @SubscribeEvent
    public static void sendClearFluidContainerTextComponents(OnDatapackSyncEvent event) {
        BnCNetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClearKegFluidContainerComponentsPacket());
    }
}

