/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import umpaz.brewinandchewin.common.registry.BnCLootConditions;

public class NullTrueBlockStateCondition
implements LootItemCondition {
    private final List<PropertyMatcher> matchers;

    protected NullTrueBlockStateCondition(List<PropertyMatcher> matchers) {
        this.matchers = matchers;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)BnCLootConditions.NULL_TRUE_BLOCK_STATE.get();
    }

    public boolean test(LootContext context) {
        BlockState blockState = (BlockState)context.m_165124_(LootContextParams.f_81461_);
        return this.matchers.stream().allMatch(propertyMatcher -> propertyMatcher.match(blockState.m_60734_().m_49965_(), blockState));
    }

    public static LootItemCondition.Builder checkState(PropertyMatcher ... matchers) {
        return () -> new NullTrueBlockStateCondition(Arrays.stream(matchers).toList());
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    private static PropertyMatcher fromJson(String name, JsonElement json) {
        if (json.isJsonPrimitive()) {
            String s2 = json.getAsString();
            return new PropertyMatcher(name, s2);
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"value");
        String min = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"min", null);
        String max = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"max", null);
        return min != null && min.equals(max) ? new PropertyMatcher(name, min) : new RangedPropertyMatcher(name, min, max);
    }

    public static class PropertyMatcher {
        private final String name;
        private final String value;

        public PropertyMatcher(String pName, String value) {
            this.name = pName;
            this.value = value;
        }

        public <S extends StateHolder<?, S>> boolean match(StateDefinition<?, S> pProperties, S pPropertyToMatch) {
            Property property = pProperties.m_61081_(this.name);
            return property == null || this.match(pPropertyToMatch, property);
        }

        protected <T extends Comparable<T>> boolean match(StateHolder<?, ?> pProperties, Property<T> pProperty) {
            Comparable t = pProperties.m_61143_(pProperty);
            Optional optional = pProperty.m_6215_(this.value);
            return optional.isPresent() && t.compareTo((Comparable)optional.get()) == 0;
        }

        public JsonElement toJson() {
            return new JsonPrimitive(this.value);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class RangedPropertyMatcher
    extends PropertyMatcher {
        @Nullable
        private final String minValue;
        @Nullable
        private final String maxValue;

        public RangedPropertyMatcher(String pName, @Nullable String pMinValue, @Nullable String pMaxValue) {
            super(pName, "");
            this.minValue = pMinValue;
            this.maxValue = pMaxValue;
        }

        @Override
        protected <T extends Comparable<T>> boolean match(StateHolder<?, ?> pProperties, Property<T> pPropertyTarget) {
            Optional optional;
            Comparable t = pProperties.m_61143_(pPropertyTarget);
            if (this.minValue != null && ((optional = pPropertyTarget.m_6215_(this.minValue)).isEmpty() || t.compareTo((Comparable)optional.get()) < 0)) {
                return false;
            }
            if (this.maxValue != null) {
                Optional optional1 = pPropertyTarget.m_6215_(this.maxValue);
                return optional1.isPresent() && t.compareTo((Comparable)optional1.get()) <= 0;
            }
            return true;
        }

        @Override
        public JsonElement toJson() {
            JsonObject jsonobject = new JsonObject();
            if (this.minValue != null) {
                jsonobject.addProperty("min", this.minValue);
            }
            if (this.maxValue != null) {
                jsonobject.addProperty("max", this.maxValue);
            }
            return jsonobject;
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<NullTrueBlockStateCondition> {
        public void serialize(JsonObject json, NullTrueBlockStateCondition condition, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            condition.matchers.forEach(p_67683_ -> obj.add(p_67683_.getName(), p_67683_.toJson()));
            json.add("properties", (JsonElement)obj);
        }

        public NullTrueBlockStateCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!json.has("properties")) {
                throw new JsonParseException("No 'properties' field within brewinandchewin:null_true_block_state predicate.");
            }
            JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)json, (String)"properties");
            ArrayList list = Lists.newArrayList();
            for (Map.Entry entry : jsonobject.entrySet()) {
                list.add(NullTrueBlockStateCondition.fromJson((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
            return new NullTrueBlockStateCondition(list);
        }
    }
}

