/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.common.block.CheeseWheelBlock;
import umpaz.brewinandchewin.common.block.PizzaBlock;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class BnCSlicingModifier
extends LootModifier {
    public static final Supplier<Codec<BnCSlicingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> BnCSlicingModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("slice").forGetter(m -> m.slice)).apply((Applicative)inst, BnCSlicingModifier::new)));
    private final Item slice;

    protected BnCSlicingModifier(LootItemCondition[] conditionsIn, Item sliceIn) {
        super(conditionsIn);
        this.slice = sliceIn;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state != null) {
            Block targetBlock = state.m_60734_();
            if (targetBlock instanceof PizzaBlock) {
                int servings = (Integer)state.m_61143_((Property)PizzaBlock.SERVINGS);
                generatedLoot.add((Object)new ItemStack((ItemLike)this.slice, servings + 1));
            } else if (targetBlock instanceof CheeseWheelBlock) {
                int servings = (Integer)state.m_61143_((Property)CheeseWheelBlock.SERVINGS);
                if (servings == 3 && !((ItemStack)context.m_165124_(LootContextParams.f_81463_)).m_204117_(ForgeTags.TOOLS_KNIVES)) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)targetBlock.m_5456_()));
                } else {
                    generatedLoot.add((Object)new ItemStack((ItemLike)this.slice, servings + 1));
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

