/*
 * Decompiled with CFR 0.152.
 */
package dynamicelectricity.client.screen;

import dynamicelectricity.common.inventory.container.ContainerMotorDC;
import dynamicelectricity.common.tile.generic.TileMotorDC;
import dynamicelectricity.core.utils.UtilsText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentFluidGauge;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ScreenMotorDC
extends GenericScreen<ContainerMotorDC> {
    public ScreenMotorDC(ContainerMotorDC screenContainer, Inventory inv, Component titleIn) {
        super((GenericContainer)screenContainer, inv, titleIn);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getEnergyInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentFluidGauge(() -> {
            TileMotorDC motor = (TileMotorDC)((ContainerMotorDC)this.f_97732_).getSafeHost();
            if (motor != null) {
                return (IFluidTank)motor.getComponent(IComponentType.FluidHandler);
            }
            return new FluidTank(1000);
        }, 150, 18));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            TileMotorDC motor = (TileMotorDC)((ContainerMotorDC)this.f_97732_).getSafeHost();
            if (motor == null) {
                return;
            }
            graphics.m_280614_(this.f_96547_, (Component)UtilsText.gui("motor.lubricant", new Object[0]).m_130940_(ChatFormatting.BLACK).m_7220_((Component)Component.m_237113_((String)("" + motor.lubricantRemaining.getValue())).m_130940_(ChatFormatting.DARK_GRAY)), this.f_97730_, 33, 0, false);
            graphics.m_280614_(this.f_96547_, (Component)UtilsText.gui("motor.generating", new Object[0]).m_130940_((Boolean)motor.running.getValue() != false ? ChatFormatting.GREEN : ChatFormatting.RED), this.f_97730_, 43, 0, false);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
    }

    private List<? extends FormattedCharSequence> getEnergyInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileMotorDC box = (TileMotorDC)((ContainerMotorDC)this.f_97732_).getSafeHost();
        if (box != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)box.getComponent(IComponentType.Electrodynamic);
            list.add(UtilsText.gui("motor.usage", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Integer)box.maxFeConsumed.getValue()).intValue(), (IDisplayUnit)DisplayUnits.FORGE_ENERGY_UNIT), (Component)DisplayUnits.TIME_TICKS.getSymbol()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(UtilsText.gui("motor.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(UtilsText.gui("motor.output", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Double)box.joulesProduced.getValue()), (IDisplayUnit)DisplayUnits.JOULES), (Component)DisplayUnits.TIME_TICKS.getSymbol()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(UtilsText.gui("motor.wattage", ChatFormatter.getChatDisplayShort((double)((Double)box.joulesProduced.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        }
        return list;
    }
}

