/*
 * Decompiled with CFR 0.152.
 */
package dynamicelectricity.common.tile.generic;

import dynamicelectricity.common.inventory.container.ContainerMotorAC;
import dynamicelectricity.common.tags.DynamicElectricityTags;
import dynamicelectricity.registry.DynamicElectricitySounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;

public class TileMotorAC
extends GenericTile
implements IEnergyStorage,
ITickableSound {
    public static double CONVERSION_EFFICIENCY = 1.0;
    public static final int LUBRICANT_PER_MB = 20000;
    public final SingleProperty<Integer> feProduced;
    public final SingleProperty<Integer> feStored;
    public final SingleProperty<Double> joulesConsumed;
    public final SingleProperty<Integer> lubricantRemaining;
    public final SingleProperty<Boolean> running;
    public final SingleProperty<Boolean> hasRedstoneSignal;
    private boolean isPlaying = false;
    public final int energyTier;

    public TileMotorAC(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int energyTier, double joulesCons, String name) {
        super(tileEntityTypeIn, pos, state);
        this.energyTier = energyTier;
        this.joulesConsumed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "joulesconsumed", (Object)joulesCons));
        this.feProduced = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "feproduced", (Object)((int)(joulesCons * CONVERSION_EFFICIENCY))));
        this.feStored = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "festored", (Object)0));
        this.lubricantRemaining = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "lubricantremaining", (Object)0));
        this.running = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "running", (Object)false));
        this.hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).maxJoules(joulesCons * 20.0).voltage(Math.pow(2.0, energyTier) * 120.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1)).valid(TileMotorAC.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("motorac" + name, (GenericTile)this).createMenu((id, player) -> new ContainerMotorAC((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(1000, (GenericTile)this, "lubricant").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setValidFluidTags(new TagKey[]{DynamicElectricityTags.Fluids.LUBRICANT}));
    }

    public void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        Direction facing = this.getFacing();
        boolean canRun = false;
        ComponentFluidHandlerSimple tank = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        if (electro.getJoulesStored() >= (Double)this.joulesConsumed.getValue()) {
            if ((Integer)this.lubricantRemaining.getValue() > 0) {
                this.lubricantRemaining.setValue((Object)((Integer)this.lubricantRemaining.getValue() - 1));
                canRun = true;
            } else if (tank.getFluidAmount() > 0 && (Integer)this.lubricantRemaining.getValue() == 0) {
                tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.lubricantRemaining.setValue((Object)20000);
            }
        }
        FluidUtilities.drainItem((GenericTile)this, (FluidTank[])((ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler)).asArray());
        this.running.setValue((Object)canRun);
        if (!canRun) {
            return;
        }
        electro.joules(electro.getJoulesStored() - (Double)this.joulesConsumed.getValue());
        this.feStored.setValue(this.feProduced.getValue());
        BlockPos pos = this.m_58899_().m_121945_(facing);
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile == null) {
            return;
        }
        this.handleFe(tile, facing);
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.shouldPlaySound() && !this.isPlaying) {
            this.isPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)DynamicElectricitySounds.SOUND_MOTORRUNNING.get()), (BlockEntity)this, (boolean)true);
        }
    }

    private void handleFe(BlockEntity tile, Direction motorFacing) {
        if (tile == null) {
            return;
        }
        IEnergyStorage feCap = (IEnergyStorage)tile.getCapability(ForgeCapabilities.ENERGY, motorFacing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_FE);
        if (feCap == CapabilityUtils.EMPTY_FE) {
            return;
        }
        int amtAccepted = feCap.receiveEnergy(((Integer)this.feStored.getValue()).intValue(), true);
        if (amtAccepted > 0) {
            feCap.receiveEnergy(amtAccepted, false);
            this.feStored.setValue((Object)((Integer)this.feStored.getValue() - amtAccepted));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == this.getFacing()) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int amtExtracted;
        int n = amtExtracted = maxExtract >= (Integer)this.feStored.getValue() ? (Integer)this.feStored.getValue() : maxExtract;
        if (!simulate) {
            this.feStored.setValue((Object)((Integer)this.feStored.getValue() - amtExtracted));
        }
        return amtExtracted;
    }

    public int getEnergyStored() {
        return (Integer)this.feStored.getValue();
    }

    public int getMaxEnergyStored() {
        return (Integer)this.feProduced.getValue();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public void setNotPlaying() {
        this.isPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.running.getValue();
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

