/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.common.block.connect.BlockWire;
import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.block.voxelshapes.ElectrodynamicsVoxelShapes;
import electrodynamics.common.entity.ElectrodynamicsAttributeModifiers;
import electrodynamics.common.event.ServerEventHandler;
import electrodynamics.common.eventbus.RegisterWiresEvent;
import electrodynamics.common.packet.NetworkHandler;
import electrodynamics.common.reloadlistener.CoalGeneratorFuelRegister;
import electrodynamics.common.reloadlistener.CombustionFuelRegister;
import electrodynamics.common.reloadlistener.ThermoelectricGeneratorHeatRegister;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.settings.OreConfig;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.UnifiedElectrodynamicsRegister;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import voltaic.prefab.configuration.ConfigurationHandler;

@Mod(value="electrodynamics")
@Mod.EventBusSubscriber(modid="electrodynamics", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Electrodynamics {
    public static final String ID = "electrodynamics";
    public static final String NAME = "Electrodynamics";

    public Electrodynamics() {
        ConfigurationHandler.registerConfig(ElectroConstants.class);
        ConfigurationHandler.registerConfig(OreConfig.class);
        ElectrodynamicsBlockStates.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        UnifiedElectrodynamicsRegister.register(bus);
        ElectrodynamicsAttributeModifiers.init();
        bus.register(RegisterWiresEvent.class);
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        ServerEventHandler.init();
        NetworkHandler.init();
        CombustionFuelRegister.INSTANCE = new CombustionFuelRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        CoalGeneratorFuelRegister.INSTANCE = new CoalGeneratorFuelRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        ThermoelectricGeneratorHeatRegister.INSTANCE = new ThermoelectricGeneratorHeatRegister().subscribeAsSyncable(NetworkHandler.CHANNEL);
        event.enqueueWork(() -> {
            RegisterWiresEvent wiresEvent = new RegisterWiresEvent();
            MinecraftForge.EVENT_BUS.post((Event)wiresEvent);
            wiresEvent.process();
        });
        ElectrodynamicsVoxelShapes.init();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ElectrodynamicsClientRegister.setup());
    }

    @SubscribeEvent
    public static void registerWires(RegisterWiresEvent event) {
        for (BlockWire wire : ElectrodynamicsBlocks.BLOCKS_WIRE.getAllValues()) {
            event.registerWire(wire);
        }
    }

    public static final ResourceLocation rl(String path) {
        return new ResourceLocation(ID, path);
    }
}

