/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.common.tile.electricitygrid.transformer.TileAdvancedTransformer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;

public abstract class RenderAdvancedTransformer
extends AbstractTileRenderer<TileAdvancedTransformer> {
    public RenderAdvancedTransformer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileAdvancedTransformer tile, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing = tile.getFacing();
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent transfer = Component.m_237113_((String)this.getTurnsString(tile));
        float scale = 0.0215f / ((float)font.m_92852_((FormattedText)transfer) / 16.0f);
        float textX = (float)(-font.m_92852_((FormattedText)transfer)) / 2.0f;
        poseStack.m_85836_();
        Direction clockwise = facing.m_122427_();
        poseStack.m_85837_(0.5 + (double)clockwise.m_122429_() * 0.438, 0.55 + (double)clockwise.m_122430_() / 2.0, 0.5 + (double)clockwise.m_122431_() * 0.438);
        RenderAdvancedTransformer.rotateMatrix(poseStack, clockwise);
        poseStack.m_85841_(-scale, -scale, -scale);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        font.m_272077_((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
        poseStack.m_85836_();
        Direction counterClockwise = facing.m_122428_();
        poseStack.m_85837_(0.5 - (double)clockwise.m_122429_() * 0.438, 0.55 + (double)clockwise.m_122430_() / 2.0, 0.5 - (double)clockwise.m_122431_() * 0.438);
        RenderAdvancedTransformer.rotateMatrix(poseStack, counterClockwise);
        poseStack.m_85841_(-scale, -scale, -scale);
        matrix4f = poseStack.m_85850_().m_252922_();
        font.m_272077_((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }

    public abstract String getTurnsString(TileAdvancedTransformer var1);

    private static void rotateMatrix(PoseStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)-90.0f, (float)0.0f));
                break;
            }
            case SOUTH: {
                stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)180.0f, (float)0.0f));
                break;
            }
            case WEST: {
                stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)90.0f, (float)0.0f));
                break;
            }
        }
    }

    public static class RenderAdvancedDowngradeTransformer
    extends RenderAdvancedTransformer {
        public RenderAdvancedDowngradeTransformer(BlockEntityRendererProvider.Context context) {
            super(context);
        }

        @Override
        public String getTurnsString(TileAdvancedTransformer transformer) {
            int ratio = (int)(1.0 / (Double)transformer.coilRatio.getValue());
            return ratio + " : 1";
        }
    }

    public static class RenderAdvancedUpgradeTransformer
    extends RenderAdvancedTransformer {
        public RenderAdvancedUpgradeTransformer(BlockEntityRendererProvider.Context context) {
            super(context);
        }

        @Override
        public String getTurnsString(TileAdvancedTransformer transformer) {
            int ratio = ((Double)transformer.coilRatio.getValue()).intValue();
            return "1 : " + ratio;
        }
    }
}

