/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.common.tile.electricitygrid.TileMultimeterBlock;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderMultimeterBlock
extends AbstractTileRenderer<TileMultimeterBlock> {
    public static final Direction[] DIRS_TO_CHECK = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

    public RenderMultimeterBlock(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileMultimeterBlock multimeter, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        for (Direction dir : DIRS_TO_CHECK) {
            if (dir == multimeter.getFacing()) continue;
            Font font = Minecraft.m_91087_().f_91062_;
            stack.m_85836_();
            stack.m_85837_(0.5 + (double)dir.m_122429_() / 1.999, 0.85 + (double)dir.m_122430_() / 2.0, 0.5 + (double)dir.m_122431_() / 1.999);
            RenderMultimeterBlock.rotateMatrix(stack, dir);
            MutableComponent transfer = ElectroTextUtils.gui("multimeterblock.transfer", ChatFormatter.getDisplayShort((double)((Double)multimeter.joules.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT, (int)2));
            float scale = 0.0215f / ((float)font.m_92852_((FormattedText)transfer) / 32.0f);
            stack.m_85841_(-scale, -scale, -scale);
            Matrix4f matrix4f = stack.m_85850_().m_252922_();
            float textX = (float)(-font.m_92852_((FormattedText)transfer)) / 2.0f;
            font.m_272077_((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            stack.m_85849_();
            stack.m_85836_();
            stack.m_85837_(0.5 + (double)dir.m_122429_() / 1.999, 0.7 + (double)dir.m_122430_() / 2.0, 0.5 + (double)dir.m_122431_() / 1.999);
            RenderMultimeterBlock.rotateMatrix(stack, dir);
            MutableComponent voltage = ElectroTextUtils.gui("multimeterblock.voltage", ChatFormatter.getDisplayShort((double)((Double)multimeter.voltage.getValue()), (IDisplayUnit)DisplayUnits.VOLTAGE, (int)2));
            scale = 0.0215f / ((float)font.m_92852_((FormattedText)voltage) / 32.0f);
            stack.m_85841_(-scale, -scale, -scale);
            matrix4f = stack.m_85850_().m_252922_();
            textX = (float)(-font.m_92852_((FormattedText)voltage)) / 2.0f;
            font.m_272077_((Component)voltage, textX, 0.0f, Color.WHITE.color(), false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            stack.m_85849_();
            stack.m_85836_();
            stack.m_85837_(0.5 + (double)dir.m_122429_() / 1.999, 0.55 + (double)dir.m_122430_() / 2.0, 0.5 + (double)dir.m_122431_() / 1.999);
            RenderMultimeterBlock.rotateMatrix(stack, dir);
            double minVolt = (Double)multimeter.minVoltage.getValue();
            if (minVolt < 0.0) {
                minVolt = (Double)multimeter.voltage.getValue();
            }
            MutableComponent minVoltage = ElectroTextUtils.gui("multimeterblock.minvoltage", ChatFormatter.getDisplayShort((double)minVolt, (IDisplayUnit)DisplayUnits.VOLTAGE, (int)2));
            scale = 0.0215f / ((float)font.m_92852_((FormattedText)minVoltage) / 32.0f);
            stack.m_85841_(-scale, -scale, -scale);
            matrix4f = stack.m_85850_().m_252922_();
            textX = (float)(-font.m_92852_((FormattedText)minVoltage)) / 2.0f;
            font.m_272077_((Component)minVoltage, textX, 0.0f, Color.WHITE.color(), false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            stack.m_85849_();
            stack.m_85836_();
            stack.m_85837_(0.5 + (double)dir.m_122429_() / 1.999, 0.4 + (double)dir.m_122430_() / 2.0, 0.5 + (double)dir.m_122431_() / 1.999);
            RenderMultimeterBlock.rotateMatrix(stack, dir);
            MutableComponent resistance = ElectroTextUtils.gui("multimeterblock.resistance", ChatFormatter.getDisplayShort((double)((Double)multimeter.resistance.getValue()), (IDisplayUnit)DisplayUnits.RESISTANCE, (int)2));
            scale = 0.0215f / ((float)font.m_92852_((FormattedText)resistance) / 32.0f);
            stack.m_85841_(-scale, -scale, -scale);
            matrix4f = stack.m_85850_().m_252922_();
            textX = (float)(-font.m_92852_((FormattedText)resistance)) / 2.0f;
            font.m_272077_((Component)resistance, textX, 0.0f, Color.WHITE.color(), false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            stack.m_85849_();
            stack.m_85836_();
            stack.m_85837_(0.5 + (double)dir.m_122429_() / 1.999, 0.25 + (double)dir.m_122430_() / 2.0, 0.5 + (double)dir.m_122431_() / 1.999);
            RenderMultimeterBlock.rotateMatrix(stack, dir);
            MutableComponent loss = ElectroTextUtils.gui("multimeterblock.loss", ChatFormatter.getDisplayShort((double)((Double)multimeter.loss.getValue() * 20.0), (IDisplayUnit)DisplayUnits.WATT, (int)2));
            scale = 0.0215f / ((float)font.m_92852_((FormattedText)loss) / 32.0f);
            stack.m_85841_(-scale, -scale, -scale);
            matrix4f = stack.m_85850_().m_252922_();
            textX = (float)(-font.m_92852_((FormattedText)loss)) / 2.0f;
            font.m_272077_((Component)loss, textX, 0.0f, Color.WHITE.color(), false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            stack.m_85849_();
        }
    }

    private static void rotateMatrix(PoseStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)-90.0f, (float)0.0f));
                break;
            }
            case SOUTH: {
                stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)180.0f, (float)0.0f));
                break;
            }
            case WEST: {
                stack.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)90.0f, (float)0.0f));
                break;
            }
        }
    }
}

