/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.armor.types;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.client.model.armor.ModelCompositeArmor;
import electrodynamics.common.item.gear.armor.ICustomArmor;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsCreativeTabs;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import voltaic.common.item.gear.ItemVoltaicArmor;

public class ItemCompositeArmor
extends ItemVoltaicArmor {
    public static final String ARMOR_TEXTURE_LOCATION = "electrodynamics:textures/model/armor/compositearmor.png";

    public ItemCompositeArmor(ArmorItem.Type slot) {
        super((ArmorMaterial)CompositeArmor.COMPOSITE_ARMOR, slot, new Item.Properties().m_41487_(1).m_41486_().setNoRepair(), () -> (CreativeModeTab)ElectrodynamicsCreativeTabs.MAIN.get());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> properties) {
                boolean hasChest;
                ItemStack[] armorPiecesArray = new ItemStack[]{new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMPOSITEHELMET.get()), new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMPOSITECHESTPLATE.get()), new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMPOSITELEGGINGS.get()), new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMPOSITEBOOTS.get())};
                ArrayList armorPieces = new ArrayList();
                entity.m_6168_().forEach(armorPieces::add);
                boolean isBoth = ((ItemStack)armorPieces.get(0)).m_41720_() == armorPiecesArray[3].m_41720_() && ((ItemStack)armorPieces.get(1)).m_41720_() == armorPiecesArray[2].m_41720_();
                boolean bl = hasChest = ((ItemStack)armorPieces.get(2)).m_41720_() == armorPiecesArray[1].m_41720_();
                ModelCompositeArmor model = isBoth ? (hasChest ? new ModelCompositeArmor(ElectrodynamicsClientRegister.COMPOSITE_ARMOR_LAYER_COMB_CHEST.m_171564_(), ItemCompositeArmor.this.m_40402_()) : new ModelCompositeArmor(ElectrodynamicsClientRegister.COMPOSITE_ARMOR_LAYER_COMB_NOCHEST.m_171564_(), ItemCompositeArmor.this.m_40402_())) : (ItemCompositeArmor.this.m_40402_() == EquipmentSlot.FEET ? new ModelCompositeArmor(ElectrodynamicsClientRegister.COMPOSITE_ARMOR_LAYER_BOOTS.m_171564_(), ItemCompositeArmor.this.m_40402_()) : (hasChest ? new ModelCompositeArmor(ElectrodynamicsClientRegister.COMPOSITE_ARMOR_LAYER_LEG_CHEST.m_171564_(), ItemCompositeArmor.this.m_40402_()) : new ModelCompositeArmor(ElectrodynamicsClientRegister.COMPOSITE_ARMOR_LAYER_LEG_NOCHEST.m_171564_(), ItemCompositeArmor.this.m_40402_())));
                model.f_102817_ = properties.f_102817_;
                model.f_102609_ = properties.f_102609_;
                model.f_102610_ = properties.f_102610_;
                return model;
            }
        });
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        super.addCreativeModeItems(group, items);
        if (this.m_40402_() == EquipmentSlot.CHEST) {
            ItemStack filled = new ItemStack((ItemLike)this);
            CompoundTag tag = filled.m_41784_();
            tag.m_128405_("plates", 2);
            items.add(filled);
        }
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.CHEST) {
            ItemCompositeArmor.staticAppendHoverText(stack, worldIn, tooltip, flagIn);
        }
    }

    protected static void staticAppendHoverText(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int plates = stack.m_41782_() ? stack.m_41783_().m_128451_("plates") : 0;
        tooltip.add((Component)ElectroTextUtils.tooltip("ceramicplatecount", Component.m_237115_((String)("" + plates))).m_130940_(ChatFormatting.AQUA));
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ARMOR_TEXTURE_LOCATION;
    }

    public static enum CompositeArmor implements ICustomArmor
    {
        COMPOSITE_ARMOR("electrodynamics:composite", new int[]{6, 12, 16, 6}, 2.0f);

        private final String name;
        private final int[] damageReductionAmountArray;
        private final float toughness;

        private CompositeArmor(String name, int[] damageReductionAmountArray, float toughness) {
            this.name = name;
            this.damageReductionAmountArray = damageReductionAmountArray;
            this.toughness = toughness;
        }

        public SoundEvent m_7344_() {
            return (SoundEvent)ElectrodynamicsSounds.SOUND_EQUIPHEAVYARMOR.get();
        }

        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return 4.0f;
        }

        public int m_266425_(ArmorItem.Type type) {
            return 2000;
        }

        public int m_7366_(ArmorItem.Type type) {
            return this.damageReductionAmountArray[type.ordinal()];
        }
    }
}

