/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import electrodynamics.common.item.gear.tools.electric.utils.ElectricItemTier;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import voltaic.api.creativetab.CreativeTabSupplier;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemElectricBaton
extends SwordItem
implements IItemElectric,
CreativeTabSupplier {
    private final ElectricItemProperties properties;
    private final Supplier<CreativeModeTab> creativeTab;

    public ItemElectricBaton(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super((Tier)ElectricItemTier.DRILL, 12, -2.4f, properties.m_41503_(0));
        this.properties = properties;
        this.creativeTab = creativeTab;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.getJoulesStored(stack) > this.properties.extract.getJoules() ? super.getAttributeModifiers(slot, stack) : ImmutableMultimap.of();
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.extractPower(stack, this.properties.extract.getJoules(), false);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)worldIn, tooltip);
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public Item getDefaultStorageBattery() {
        return (Item)ElectrodynamicsItems.ITEM_LITHIUMBATTERY.get();
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }

    public boolean isAllowedInCreativeTab(CreativeModeTab tab) {
        return this.creativeTab.get() == tab;
    }

    public boolean hasCreativeTab() {
        return this.creativeTab != null;
    }
}

