/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.packet.types.server;

import electrodynamics.common.tile.electricitygrid.generators.TileCreativePowerSource;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.network.NetworkEvent;

public class PacketPowerSetting {
    private final int voltage;
    private final int power;
    private final BlockPos pos;

    public PacketPowerSetting(int voltage, int power, BlockPos target) {
        this.voltage = voltage;
        this.power = power;
        this.pos = target;
    }

    public static void handle(PacketPowerSetting message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileCreativePowerSource tile;
            ServerLevel world = ((NetworkEvent.Context)context.get()).getSender().m_284548_();
            if (world != null && (tile = (TileCreativePowerSource)world.m_7702_(message.pos)) != null) {
                tile.voltage.setValue((Object)message.voltage);
                tile.power.setValue((Object)message.power);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketPowerSetting pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.voltage);
        buf.writeInt(pkt.power);
        buf.m_130064_(pkt.pos);
    }

    public static PacketPowerSetting decode(FriendlyByteBuf buf) {
        return new PacketPowerSetting(buf.readInt(), buf.readInt(), buf.m_130135_());
    }
}

