/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import electrodynamics.common.packet.types.client.PacketSetClientThermoGenSources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import voltaic.Voltaic;

public class ThermoelectricGeneratorHeatRegister
extends SimplePreparableReloadListener<JsonObject> {
    public static ThermoelectricGeneratorHeatRegister INSTANCE = null;
    public static final String FOLDER = "machines";
    public static final String FILE_NAME = "thermo_gen_heat_sources";
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final Gson GSON = new Gson();
    private final HashMap<Fluid, Double> heatSources = new HashMap();
    private final HashMap<TagKey<Fluid>, Double> tags = new HashMap();
    private final Logger logger = Voltaic.LOGGER;

    protected JsonObject prepare(ResourceManager manager, ProfilerFiller profiler) {
        JsonObject combined = new JsonObject();
        ArrayList resources = new ArrayList(manager.m_214159_(FOLDER, ThermoelectricGeneratorHeatRegister::isJson).entrySet());
        Collections.reverse(resources);
        for (Map.Entry entry : resources) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            String namespace = loc.m_135827_();
            String filePath = loc.m_135815_();
            String dataPath = filePath.substring(FOLDER.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonFile = new ResourceLocation(namespace, dataPath);
            Resource resource = (Resource)entry.getValue();
            try {
                InputStream inputStream = resource.m_215507_();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                    json.entrySet().forEach(set -> {
                        if (combined.has((String)set.getKey())) {
                            combined.remove((String)set.getKey());
                        }
                        combined.add((String)set.getKey(), (JsonElement)set.getValue());
                    });
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)FOLDER, (Object)jsonFile, (Object)loc, (Object)resource.m_215506_(), (Object)exception);
            }
        }
        return combined;
    }

    protected void apply(JsonObject json, ResourceManager manager, ProfilerFiller profiler) {
        this.heatSources.clear();
        this.tags.clear();
        json.entrySet().forEach(set -> {
            String key = (String)set.getKey();
            Double value = ((JsonElement)set.getValue()).getAsDouble();
            if (key.contains("#")) {
                key = key.substring(1);
                this.tags.put((TagKey<Fluid>)FluidTags.create((ResourceLocation)new ResourceLocation(key)), value);
            } else {
                this.heatSources.put((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(key)), value);
            }
        });
    }

    public void generateTagValues() {
        this.tags.forEach((tag, value) -> ForgeRegistries.FLUIDS.tags().getTag(tag).forEach(fluid -> {
            if (!this.heatSources.containsKey(fluid)) {
                this.heatSources.put((Fluid)fluid, (Double)value);
            }
        }));
        this.tags.clear();
    }

    public void setClientValues(HashMap<Fluid, Double> fuels) {
        this.heatSources.clear();
        this.heatSources.putAll(fuels);
    }

    public ThermoelectricGeneratorHeatRegister subscribeAsSyncable(SimpleChannel channel) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(channel));
        return this;
    }

    public HashMap<Fluid, Double> getHeatSources() {
        return this.heatSources;
    }

    public boolean isHeatSource(Fluid fluid) {
        return this.heatSources.containsKey(fluid);
    }

    public double getHeatMultiplier(Fluid fluid) {
        return this.heatSources.getOrDefault(fluid, 0.0);
    }

    private Consumer<OnDatapackSyncEvent> getDatapackSyncListener(SimpleChannel channel) {
        return event -> {
            this.generateTagValues();
            ServerPlayer player = event.getPlayer();
            PacketSetClientThermoGenSources packet = new PacketSetClientThermoGenSources(this.heatSources);
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            channel.send(target, (Object)packet);
        };
    }

    private static boolean isJson(ResourceLocation filename) {
        return filename.m_135815_().contains("thermo_gen_heat_sources.json");
    }
}

