/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.transformer;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.prefab.sound.SoundBarrierMethods;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public abstract class TileGenericTransformer
extends GenericTile
implements ITickableSound {
    public static final double MAX_VOLTAGE_CAP = 120.0 * Math.pow(2.0, 8.0);
    public static final double MIN_VOLTAGE_CAP = 120.0 / Math.pow(2.0, 8.0);
    public CachedTileOutput output;
    public final SingleProperty<TransferPack> lastTransfer = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.TRANSFER_PACK, "lasttransfer", (Object)TransferPack.EMPTY))).setNoSave();
    public final SingleProperty<Long> lastTransferTime = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.LONG, "lasttransfertime", (Object)0L))).setNoSave();
    public boolean locked = false;
    private boolean isPlayingSound = false;
    public static final BlockEntityUtils.MachineDirection OUTPUT = BlockEntityUtils.MachineDirection.FRONT;
    public static final BlockEntityUtils.MachineDirection INPUT = BlockEntityUtils.MachineDirection.BACK;

    public TileGenericTransformer(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        if (ElectroConstants.SHOULD_TRANSFORMER_HUM) {
            this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        }
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, true).receivePower(this::receivePower).getConnectedLoad(this::getConnectedLoad).setOutputDirections(new BlockEntityUtils.MachineDirection[]{OUTPUT}).setInputDirections(new BlockEntityUtils.MachineDirection[]{INPUT}).voltage(-1.0).getAmpacity(this::getAmpacity).getMinimumVoltage(this::getMinimumVoltage));
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.f_58857_.m_46467_() - (Long)this.lastTransferTime.getValue() > 20L) {
            this.lastTransfer.setValue((Object)TransferPack.EMPTY);
        }
        if (!this.isPlayingSound && this.shouldPlaySound()) {
            this.isPlayingSound = true;
            SoundBarrierMethods.playTransformerSound((SoundEvent)ElectrodynamicsSounds.SOUND_TRANSFORMERHUM.get(), SoundSource.BLOCKS, this, 1.0f, 1.0f, true);
        }
    }

    public TransferPack receivePower(TransferPack transfer, boolean debug) {
        Direction facing = this.getFacing();
        if (this.locked) {
            return TransferPack.EMPTY;
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing));
        }
        if (this.output.getSafe() == null) {
            return TransferPack.EMPTY;
        }
        double resultVoltage = transfer.getVoltage() * this.getCoilRatio();
        if (resultVoltage != 0.0) {
            resultVoltage = Mth.m_14008_((double)resultVoltage, (double)MIN_VOLTAGE_CAP, (double)MAX_VOLTAGE_CAP);
        }
        this.locked = true;
        TransferPack returner = ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), facing.m_122424_(), TransferPack.joulesVoltage((double)(transfer.getJoules() * (double)ElectroConstants.TRANSFORMER_EFFICIENCY), (double)resultVoltage), debug);
        this.locked = false;
        TransferPack toReturn = TransferPack.joulesVoltage((double)(returner.getJoules() / (double)ElectroConstants.TRANSFORMER_EFFICIENCY), (double)(returner.getVoltage() / this.getCoilRatio()));
        if (!debug && toReturn.getVoltage() > 0.0) {
            this.lastTransfer.setValue((Object)toReturn);
            this.lastTransferTime.setValue((Object)this.f_58857_.m_46467_());
        }
        return toReturn;
    }

    public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile lastEnergy, Direction dir) {
        Direction facing = this.getFacing();
        if (facing.m_122424_() != dir) {
            return TransferPack.EMPTY;
        }
        if (this.locked) {
            return TransferPack.EMPTY;
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing));
        }
        if (this.output.getSafe() == null) {
            return TransferPack.EMPTY;
        }
        ICapabilityElectrodynamic.LoadProfile transformed = new ICapabilityElectrodynamic.LoadProfile(TransferPack.joulesVoltage((double)(lastEnergy.lastUsage().getJoules() * (double)ElectroConstants.TRANSFORMER_EFFICIENCY), (double)(lastEnergy.lastUsage().getVoltage() * this.getCoilRatio())), TransferPack.joulesVoltage((double)(lastEnergy.maximumAvailable().getJoules() * (double)ElectroConstants.TRANSFORMER_EFFICIENCY), (double)(lastEnergy.maximumAvailable().getVoltage() * this.getCoilRatio())));
        this.locked = true;
        BlockEntity outputTile = (BlockEntity)this.output.getSafe();
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)outputTile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, dir).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        TransferPack returner = TransferPack.EMPTY;
        if (electro != CapabilityUtils.EMPTY_ELECTRO) {
            returner = electro.getConnectedLoad(transformed, dir);
        }
        this.locked = false;
        return TransferPack.joulesVoltage((double)(returner.getJoules() / (double)ElectroConstants.TRANSFORMER_EFFICIENCY), (double)returner.getVoltage());
    }

    public double getMinimumVoltage() {
        Direction facing = this.getFacing();
        if (this.locked) {
            return 0.0;
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing));
        }
        if (this.output.getSafe() == null) {
            return -1.0;
        }
        this.locked = true;
        BlockEntity outputTile = (BlockEntity)this.output.getSafe();
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)outputTile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, facing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        double minimumVoltage = -1.0;
        if (electro != CapabilityUtils.EMPTY_ELECTRO) {
            minimumVoltage = electro.getMinimumVoltage();
        }
        this.locked = false;
        return minimumVoltage;
    }

    public double getAmpacity() {
        Direction facing = this.getFacing();
        if (this.locked) {
            return 0.0;
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing));
        }
        if (this.output.getSafe() == null) {
            return -1.0;
        }
        this.locked = true;
        BlockEntity outputTile = (BlockEntity)this.output.getSafe();
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)outputTile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, facing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        double ampacity = -1.0;
        if (electro != CapabilityUtils.EMPTY_ELECTRO) {
            ampacity = electro.getAmpacity();
        }
        this.locked = false;
        return ampacity;
    }

    public void onEntityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_ || ((TransferPack)this.lastTransfer.getValue()).getJoules() <= 0.0 || level.m_46467_() - (Long)this.lastTransferTime.getValue() > 20L) {
            return;
        }
        ElectricityUtils.electrecuteEntity(entity, (TransferPack)this.lastTransfer.getValue());
        this.lastTransfer.setValue((Object)TransferPack.EMPTY);
        this.lastTransferTime.setValue((Object)0L);
    }

    public void setNotPlaying() {
        this.isPlayingSound = false;
    }

    public boolean shouldPlaySound() {
        return ((TransferPack)this.lastTransfer.getValue()).getVoltage() > 0.0 && ((TransferPack)this.lastTransfer.getValue()).getJoules() > 0.0;
    }

    public abstract double getCoilRatio();

    public static final class TileUpgradeTransformer
    extends TileGenericTransformer {
        public TileUpgradeTransformer(BlockPos worldPosition, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_UPGRADETRANSFORMER.get(), worldPosition, blockState);
        }

        @Override
        public double getCoilRatio() {
            return 2.0;
        }

        public InteractionResult use(Player arg0, InteractionHand arg1, BlockHitResult arg2) {
            return InteractionResult.FAIL;
        }
    }

    public static final class TileDowngradeTransformer
    extends TileGenericTransformer {
        public TileDowngradeTransformer(BlockPos worldPosition, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_DOWNGRADETRANSFORMER.get(), worldPosition, blockState);
        }

        @Override
        public double getCoilRatio() {
            return 0.5;
        }

        public InteractionResult use(Player arg0, InteractionHand arg1, BlockHitResult arg2) {
            return InteractionResult.FAIL;
        }
    }
}

