/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerChemicalMixer;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericMaterialTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileChemicalMixer
extends GenericMaterialTile {
    public static final int MAX_TANK_CAPACITY = 5000;

    public TileChemicalMixer(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CHEMICALMIXER.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(240.0));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setTanks(1, 1, new int[]{5000}, new int[]{5000}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT}).setRecipeType((RecipeType)ElectrodynamicsRecipies.CHEMICAL_MIXER_TYPE.get()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 0, 0).bucketInputs(1).bucketOutputs(1).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM}).validUpgrades(ContainerChemicalMixer.VALID_UPGRADES).valid(TileChemicalMixer.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess((component, procNumber) -> component.outputToFluidPipe().consumeBucket().dispenseBucket().canProcessFluidItem2FluidRecipe(procNumber.intValue(), (RecipeType)ElectrodynamicsRecipies.CHEMICAL_MIXER_TYPE.get())).process(ComponentProcessor::processFluidItem2FluidRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.chemicalmixer.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerChemicalMixer((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0)) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_() * 0.4 + 0.5, (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(1.0);
    }
}

