/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.mineralgrinder;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.particle.ParticleAPI;
import voltaic.common.inventory.container.ContainerO2OProcessor;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileMineralGrinder
extends GenericTile
implements ITickableSound {
    private final int procCount;
    public long clientRunningTicks = 0L;
    private boolean isSoundPlaying = false;

    public TileMineralGrinder(BlockPos pos, BlockState state) {
        this((BlockEntityType)ElectrodynamicsTiles.TILE_MINERALGRINDER.get(), 1, pos, state);
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.mineralgrinder.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerO2OProcessor(id.intValue(), player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public TileMineralGrinder(BlockEntityType<?> type, int procCount, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.procCount = procCount;
        int inputsPerProc = 1;
        int outputPerProc = 1;
        int biprodsPerProc = 1;
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(120.0 * Math.pow(2.0, procCount - 1)));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(procCount, inputsPerProc, outputPerProc, biprodsPerProc).upgrades(3)).validUpgrades(ContainerO2OProcessor.VALID_UPGRADES).valid(TileMineralGrinder.machineValidator()).implementMachineInputsAndOutputs());
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this, procCount).canProcess((component, procNumber) -> component.canProcessItem2ItemRecipe(procNumber.intValue(), (RecipeType)ElectrodynamicsRecipies.MINERAL_GRINDER_TYPE.get())).process(ComponentProcessor::processItem2ItemRecipe));
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_() * 0.2 + 0.8, (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
        for (int i = 0; i < this.procCount; ++i) {
            ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
            ItemStack stack = (ItemStack)inv.getInputsForProcessor(i).get(0);
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) continue;
            BlockItem it = (BlockItem)item;
            Block block = it.m_40614_();
            double d4 = this.f_58857_.f_46441_.m_188500_() * 12.0 / 16.0 + 0.5 - 0.375;
            double d6 = this.f_58857_.f_46441_.m_188500_() * 12.0 / 16.0 + 0.5 - 0.375;
            ParticleAPI.addGrindedParticle((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + d4), (double)((double)this.f_58858_.m_123342_() + 0.8), (double)((double)this.f_58858_.m_123343_() + d6), (double)0.0, (double)5.0, (double)0.0, (BlockState)block.m_49966_(), (BlockPos)this.f_58858_);
        }
        ++this.clientRunningTicks;
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_MINERALGRINDER.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive();
    }

    public int getComparatorSignal() {
        return (int)((double)((ComponentProcessor)this.getComponent(IComponentType.Processor)).getTotalActive() / (double)Math.max(1, ((ComponentProcessor)this.getComponent(IComponentType.Processor)).getProcessorCount()) * 15.0);
    }
}

