/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.quarry;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerMotorComplex;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.common.item.ItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileMotorComplex
extends GenericTile
implements ITickableSound {
    public static final int DEFAULT_SPEED = Math.min(ElectroConstants.MIN_QUARRYBLOCKS_PER_TICK, 100);
    public static final int MAX_SPEED = Math.max(ElectroConstants.MAX_QUARRYBLOCKS_PER_TICK, 1);
    private boolean isSoundPlaying = false;
    public final SingleProperty<Integer> speed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "speed", (Object)DEFAULT_SPEED));
    public final SingleProperty<Double> powerMultiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "powerMultiplier", (Object)1.0));
    public final SingleProperty<Boolean> isPowered = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isPowered", (Object)false));

    public TileMotorComplex(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_MOTORCOMPLEX.get(), pos, state);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(240.0).maxJoules(ElectroConstants.MOTORCOMPLEX_USAGE_PER_TICK * 10000.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().upgrades(3)).validUpgrades(ContainerMotorComplex.VALID_UPGRADES).valid(TileMotorComplex.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.motorcomplex.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerMotorComplex((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() >= ElectroConstants.MOTORCOMPLEX_USAGE_PER_TICK * (Double)this.powerMultiplier.getValue()) {
            electro.joules(electro.getJoulesStored() - ElectroConstants.MOTORCOMPLEX_USAGE_PER_TICK * (Double)this.powerMultiplier.getValue());
            this.isPowered.setValue((Object)true);
        } else {
            this.isPowered.setValue((Object)false);
        }
    }

    private void tickClient(ComponentTickable tick) {
        if (this.shouldPlaySound() && !this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_MOTORRUNNING.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (inv.getUpgradeContents().size() > 0 && (slot >= inv.getUpgradeSlotStartIndex() || slot == -1)) {
            this.speed.setValue((Object)DEFAULT_SPEED);
            this.powerMultiplier.setValue((Object)1.0);
            for (ItemStack stack : inv.getUpgradeContents()) {
                if (stack.m_41619_()) continue;
                block5: for (int i = 0; i < stack.m_41613_(); ++i) {
                    switch (((ItemUpgrade)stack.m_41720_()).subtype) {
                        case basicspeed: {
                            this.speed.setValue((Object)((int)Math.max((double)((Integer)this.speed.getValue()).intValue() * 0.8, (double)MAX_SPEED)));
                            this.powerMultiplier.setValue((Object)((Double)this.powerMultiplier.getValue() * 3.0));
                            continue block5;
                        }
                        case advancedspeed: {
                            this.speed.setValue((Object)((int)Math.max((double)((Integer)this.speed.getValue()).intValue() * 0.5, (double)MAX_SPEED)));
                            this.powerMultiplier.setValue((Object)((Double)this.powerMultiplier.getValue() * 2.0));
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.isPowered.getValue();
    }

    public int getComparatorSignal() {
        return (Boolean)this.isPowered.getValue() != false ? 15 : 0;
    }
}

