/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas;

import electrodynamics.common.inventory.container.tile.ContainerGasPipeFilter;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class TileGasPipeFilter
extends GenericTile {
    public static final BlockEntityUtils.MachineDirection INPUT_DIR = BlockEntityUtils.MachineDirection.FRONT;
    public static final BlockEntityUtils.MachineDirection OUTPUT_DIR = BlockEntityUtils.MachineDirection.BACK;
    private boolean isLocked = false;
    public final SingleProperty[] filteredGases = new SingleProperty[]{(SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.GAS_STACK, "gasone", (Object)GasStack.EMPTY)), (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.GAS_STACK, "gastwo", (Object)GasStack.EMPTY)), (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.GAS_STACK, "gasthree", (Object)GasStack.EMPTY)), (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.GAS_STACK, "gasfour", (Object)GasStack.EMPTY))};
    public final SingleProperty<Boolean> isWhitelist = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "iswhitelist", (Object)false));

    public TileGasPipeFilter(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_GASPIPEFILTER.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentContainerProvider("gaspipefilter", (GenericTile)this).createMenu((id, inv) -> new ContainerGasPipeFilter((int)id, (Inventory)inv, (ContainerData)this.getCoordsArray())));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap != VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK || side == null || this.isLocked) {
            return LazyOptional.empty();
        }
        Direction facing = this.getFacing();
        if (side == BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileGasPipeFilter.OUTPUT_DIR.mappedDir)) {
            return LazyOptional.of(() -> CapabilityUtils.EMPTY_GAS).cast();
        }
        if (side == BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileGasPipeFilter.INPUT_DIR.mappedDir)) {
            BlockEntity output = this.f_58857_.m_7702_(this.m_58899_().m_121945_(side.m_122424_()));
            if (output == null) {
                return LazyOptional.of(() -> CapabilityUtils.EMPTY_GAS).cast();
            }
            this.isLocked = true;
            IGasHandler gas = (IGasHandler)output.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, side).orElse((Object)CapabilityUtils.EMPTY_GAS);
            this.isLocked = false;
            return gas == CapabilityUtils.EMPTY_GAS ? LazyOptional.of(() -> CapabilityUtils.EMPTY_GAS).cast() : LazyOptional.of(() -> new FilteredGasCap(gas, this.getFilteredGases(), (Boolean)this.isWhitelist.getValue())).cast();
        }
        return LazyOptional.empty();
    }

    private List<Gas> getFilteredGases() {
        ArrayList<Gas> gases = new ArrayList<Gas>();
        for (SingleProperty prop : this.filteredGases) {
            if (((GasStack)prop.getValue()).isEmpty()) continue;
            gases.add(((GasStack)prop.getValue()).getGas());
        }
        return gases;
    }

    private class FilteredGasCap
    implements IGasHandler {
        private final IGasHandler outputCap;
        private final List<Gas> validGases;
        private final boolean whitelist;

        private FilteredGasCap(IGasHandler outputCap, List<Gas> validGases, boolean whitelist) {
            this.outputCap = outputCap;
            this.validGases = validGases;
            this.whitelist = whitelist;
        }

        public int getTanks() {
            if (TileGasPipeFilter.this.isLocked) {
                return 0;
            }
            TileGasPipeFilter.this.isLocked = true;
            int count = this.outputCap.getTanks();
            TileGasPipeFilter.this.isLocked = false;
            return count;
        }

        public GasStack getGasInTank(int tank) {
            if (TileGasPipeFilter.this.isLocked) {
                return GasStack.EMPTY;
            }
            TileGasPipeFilter.this.isLocked = true;
            GasStack stack = this.outputCap.getGasInTank(tank);
            TileGasPipeFilter.this.isLocked = false;
            return stack;
        }

        public int getTankCapacity(int tank) {
            if (TileGasPipeFilter.this.isLocked) {
                return 0;
            }
            TileGasPipeFilter.this.isLocked = true;
            int cap = this.outputCap.getTankCapacity(tank);
            TileGasPipeFilter.this.isLocked = false;
            return cap;
        }

        public int getTankMaxTemperature(int tank) {
            if (TileGasPipeFilter.this.isLocked) {
                return 0;
            }
            TileGasPipeFilter.this.isLocked = true;
            int temp = this.outputCap.getTankMaxTemperature(tank);
            TileGasPipeFilter.this.isLocked = false;
            return temp;
        }

        public int getTankMaxPressure(int tank) {
            if (TileGasPipeFilter.this.isLocked) {
                return 0;
            }
            TileGasPipeFilter.this.isLocked = true;
            int pres = this.outputCap.getTankMaxPressure(tank);
            TileGasPipeFilter.this.isLocked = false;
            return pres;
        }

        public boolean isGasValid(int tank, GasStack gas) {
            if (TileGasPipeFilter.this.isLocked) {
                return false;
            }
            if (this.whitelist) {
                if (this.validGases.isEmpty()) {
                    return false;
                }
                if (this.validGases.contains(gas.getGas())) {
                    TileGasPipeFilter.this.isLocked = true;
                    boolean valid = this.outputCap.isGasValid(tank, gas);
                    TileGasPipeFilter.this.isLocked = false;
                    return valid;
                }
                return false;
            }
            if (this.validGases.isEmpty() || !this.validGases.contains(gas.getGas())) {
                TileGasPipeFilter.this.isLocked = true;
                boolean valid = this.outputCap.isGasValid(tank, gas);
                TileGasPipeFilter.this.isLocked = false;
                return valid;
            }
            return false;
        }

        public int fill(GasStack gas, GasAction action) {
            if (TileGasPipeFilter.this.isLocked) {
                return 0;
            }
            for (int i = 0; i < this.outputCap.getTanks(); ++i) {
                if (!this.isGasValid(i, gas)) continue;
                TileGasPipeFilter.this.isLocked = true;
                int fill = this.outputCap.fill(gas, action);
                TileGasPipeFilter.this.isLocked = false;
                return fill;
            }
            return 0;
        }

        public GasStack drain(GasStack gas, GasAction action) {
            if (TileGasPipeFilter.this.isLocked) {
                return GasStack.EMPTY;
            }
            TileGasPipeFilter.this.isLocked = true;
            GasStack drain = this.outputCap.drain(gas, action);
            TileGasPipeFilter.this.isLocked = false;
            return drain;
        }

        public GasStack drain(int maxFill, GasAction action) {
            if (TileGasPipeFilter.this.isLocked) {
                return GasStack.EMPTY;
            }
            TileGasPipeFilter.this.isLocked = true;
            GasStack drain = this.outputCap.drain(maxFill, action);
            TileGasPipeFilter.this.isLocked = false;
            return drain;
        }

        public int heat(int tank, int deltaTemperature, GasAction action) {
            if (TileGasPipeFilter.this.isLocked) {
                return -1;
            }
            TileGasPipeFilter.this.isLocked = true;
            int heat = this.outputCap.heat(tank, deltaTemperature, action);
            TileGasPipeFilter.this.isLocked = false;
            return heat;
        }

        public int bringPressureTo(int tank, int atm, GasAction action) {
            if (TileGasPipeFilter.this.isLocked) {
                return -1;
            }
            TileGasPipeFilter.this.isLocked = true;
            int pres = this.outputCap.bringPressureTo(tank, atm, action);
            TileGasPipeFilter.this.isLocked = false;
            return pres;
        }
    }
}

