/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.compatibility.jei;

import electrodynamics.Electrodynamics;
import electrodynamics.client.screen.tile.ScreenChemicalCrystallizer;
import electrodynamics.client.screen.tile.ScreenChemicalMixer;
import electrodynamics.client.screen.tile.ScreenElectricArcFurnace;
import electrodynamics.client.screen.tile.ScreenElectricArcFurnaceDouble;
import electrodynamics.client.screen.tile.ScreenElectricArcFurnaceTriple;
import electrodynamics.client.screen.tile.ScreenElectricFurnace;
import electrodynamics.client.screen.tile.ScreenElectricFurnaceDouble;
import electrodynamics.client.screen.tile.ScreenElectricFurnaceTriple;
import electrodynamics.client.screen.tile.ScreenElectrolyticSeparator;
import electrodynamics.client.screen.tile.ScreenFermentationPlant;
import electrodynamics.client.screen.tile.ScreenMineralWasher;
import electrodynamics.client.screen.tile.ScreenThermoelectricManipulator;
import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.reloadlistener.CombustionFuelRegister;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.generators.TileCoalGenerator;
import electrodynamics.compatibility.jei.recipecategories.fluid2gas.specificmachines.ElectrolyticSeparatorRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.fluid2item.specificmachines.ChemicalCrystallizerRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.fluiditem2fluid.specificmachines.ChemicalMixerRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.fluiditem2fluid.specificmachines.FermentationPlantRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.fluiditem2fluid.specificmachines.MineralWasherRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.EnergizedAlloyerRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.LatheRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.MineralCrusherRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.MineralGrinderRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.OxidationFurnaceRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.ReinforcedAlloyerRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.item2item.specificmachines.WireMillRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.modfurnace.ElectricArcFurnaceRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.modfurnace.ElectricFurnaceRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.thermomanipulator.CondensingGasRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.thermomanipulator.EvaporatingFluidRecipeCategory;
import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.ElectrodynamicsPsuedoRecipes;
import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoFluid2GasRecipe;
import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoGas2FluidRecipe;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.prefab.utilities.object.CombustionFuelSource;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsFluids;
import electrodynamics.registers.ElectrodynamicsGases;
import electrodynamics.registers.ElectrodynamicsRecipies;
import java.util.ArrayList;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.compatibility.jei.utils.ingredients.VoltaicJeiTypes;
import voltaic.registers.VoltaicGases;

@JeiPlugin
public class ElectrodynamicsJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = Electrodynamics.rl("jei");
    private static final int FULL_FLUID_SQUARE = 1600;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ElectricFurnaceRecipeCategory.INPUT_MACHINE, new RecipeType[]{ElectricFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnacedouble)), new RecipeType[]{ElectricFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricfurnacetriple)), new RecipeType[]{ElectricFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(WireMillRecipeCategory.INPUT_MACHINE, new RecipeType[]{WireMillRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremilldouble)), new RecipeType[]{WireMillRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.wiremilltriple)), new RecipeType[]{WireMillRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(MineralCrusherRecipeCategory.INPUT_MACHINE, new RecipeType[]{MineralCrusherRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralcrusherdouble)), new RecipeType[]{MineralCrusherRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralcrushertriple)), new RecipeType[]{MineralCrusherRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(MineralGrinderRecipeCategory.INPUT_MACHINE, new RecipeType[]{MineralGrinderRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralgrinderdouble)), new RecipeType[]{MineralGrinderRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.mineralgrindertriple)), new RecipeType[]{MineralGrinderRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ElectricArcFurnaceRecipeCategory.INPUT_MACHINE, new RecipeType[]{ElectricArcFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnacedouble)), new RecipeType[]{ElectricArcFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCKS_MACHINE.getValue((Object)SubtypeMachine.electricarcfurnacetriple)), new RecipeType[]{ElectricArcFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(OxidationFurnaceRecipeCategory.INPUT_MACHINE, new RecipeType[]{OxidationFurnaceRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(EnergizedAlloyerRecipeCategory.INPUT_MACHINE, new RecipeType[]{EnergizedAlloyerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(LatheRecipeCategory.INPUT_MACHINE, new RecipeType[]{LatheRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(MineralWasherRecipeCategory.INPUT_MACHINE, new RecipeType[]{MineralWasherRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ChemicalCrystallizerRecipeCategory.INPUT_MACHINE, new RecipeType[]{ChemicalCrystallizerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ChemicalMixerRecipeCategory.INPUT_MACHINE, new RecipeType[]{ChemicalMixerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(FermentationPlantRecipeCategory.INPUT_MACHINE, new RecipeType[]{FermentationPlantRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ReinforcedAlloyerRecipeCategory.INPUT_MACHINE, new RecipeType[]{ReinforcedAlloyerRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(ElectrolyticSeparatorRecipeCategory.INPUT_MACHINE, new RecipeType[]{ElectrolyticSeparatorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(CondensingGasRecipeCategory.INPUT_MACHINE, new RecipeType[]{CondensingGasRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCK_ADVANCED_THERMOELECTRICMANIPULATOR.get()), new RecipeType[]{CondensingGasRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(EvaporatingFluidRecipeCategory.INPUT_MACHINE, new RecipeType[]{EvaporatingFluidRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCK_ADVANCED_THERMOELECTRICMANIPULATOR.get()), new RecipeType[]{EvaporatingFluidRecipeCategory.RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = Objects.requireNonNull(mc.f_91073_);
        RecipeManager recipeManager = world.m_7465_();
        ElectrodynamicsPsuedoRecipes.initRecipes();
        registration.addRecipes(ElectricFurnaceRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44108_));
        registration.addRecipes(ElectricArcFurnaceRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44109_));
        registration.addRecipes(WireMillRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.WIRE_MILL_TYPE.get()));
        registration.addRecipes(MineralCrusherRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.MINERAL_CRUSHER_TYPE.get()));
        registration.addRecipes(MineralGrinderRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.MINERAL_GRINDER_TYPE.get()));
        registration.addRecipes(OxidationFurnaceRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.OXIDATION_FURNACE_TYPE.get()));
        registration.addRecipes(EnergizedAlloyerRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.ENERGIZED_ALLOYER_TYPE.get()));
        registration.addRecipes(LatheRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.LATHE_TYPE.get()));
        registration.addRecipes(MineralWasherRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.MINERAL_WASHER_TYPE.get()));
        registration.addRecipes(ChemicalCrystallizerRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.CHEMICAL_CRYSTALIZER_TYPE.get()));
        registration.addRecipes(ChemicalMixerRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.CHEMICAL_MIXER_TYPE.get()));
        registration.addRecipes(FermentationPlantRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.FERMENTATION_PLANT_TYPE.get()));
        registration.addRecipes(ReinforcedAlloyerRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.REINFORCED_ALLOYER_TYPE.get()));
        registration.addRecipes(ElectrolyticSeparatorRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ElectrodynamicsRecipies.ELECTROLYTIC_SEPERATOR_TYPE.get()));
        registration.addRecipes(CondensingGasRecipeCategory.RECIPE_TYPE, new ArrayList<PsuedoGas2FluidRecipe>(ElectrodynamicsPsuedoRecipes.CONDENSATION_RECIPES));
        registration.addRecipes(EvaporatingFluidRecipeCategory.RECIPE_TYPE, new ArrayList<PsuedoFluid2GasRecipe>(ElectrodynamicsPsuedoRecipes.EVAPORATION_RECIPES));
        ElectrodynamicsJEIPlugin.electrodynamicsInfoTabs(registration);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ElectricFurnaceRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ElectricArcFurnaceRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WireMillRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MineralGrinderRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MineralCrusherRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new OxidationFurnaceRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EnergizedAlloyerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new LatheRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MineralWasherRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChemicalCrystallizerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChemicalMixerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FermentationPlantRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReinforcedAlloyerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ElectrolyticSeparatorRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CondensingGasRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EvaporatingFluidRecipeCategory(guiHelper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenElectricFurnace.class, 85, 35, 22, 15, new RecipeType[]{ElectricFurnaceRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectricFurnaceDouble.class, 85, 25, 22, 35, new RecipeType[]{ElectricFurnaceRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectricFurnaceTriple.class, 85, 25, 22, 55, new RecipeType[]{ElectricFurnaceRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectricArcFurnace.class, 85, 35, 22, 15, new RecipeType[]{ElectricArcFurnaceRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectricArcFurnaceDouble.class, 85, 25, 22, 35, new RecipeType[]{ElectricArcFurnaceRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectricArcFurnaceTriple.class, 85, 25, 22, 55, new RecipeType[]{ElectricArcFurnaceRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenChemicalMixer.class, 42, 31, 22, 15, new RecipeType[]{ChemicalMixerRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenChemicalMixer.class, 97, 31, 22, 15, new RecipeType[]{ChemicalMixerRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenFermentationPlant.class, 42, 31, 22, 15, new RecipeType[]{FermentationPlantRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenFermentationPlant.class, 97, 31, 22, 15, new RecipeType[]{FermentationPlantRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenMineralWasher.class, 42, 31, 22, 15, new RecipeType[]{MineralWasherRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenMineralWasher.class, 97, 31, 22, 15, new RecipeType[]{MineralWasherRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenChemicalCrystallizer.class, 42, 35, 64, 15, new RecipeType[]{ChemicalCrystallizerRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectrolyticSeparator.class, 38, 30, 22, 15, new RecipeType[]{ElectrolyticSeparatorRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenElectrolyticSeparator.class, 78, 30, 22, 15, new RecipeType[]{ElectrolyticSeparatorRecipeCategory.RECIPE_TYPE});
        registry.addRecipeClickArea(ScreenThermoelectricManipulator.class, 62, 19, 32, 47, new RecipeType[]{CondensingGasRecipeCategory.RECIPE_TYPE, EvaporatingFluidRecipeCategory.RECIPE_TYPE});
    }

    private static void electrodynamicsInfoTabs(IRecipeRegistration registration) {
        for (Item item : TileCoalGenerator.getValidItems()) {
            ItemStack fuelStack = new ItemStack((ItemLike)item);
            registration.addIngredientInfo((Object)fuelStack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{ElectroTextUtils.jeiItemTranslated("coalgeneratorfuelsource", ChatFormatter.getChatDisplayShort((double)((double)fuelStack.getBurnTime(null) / 20.0), (IDisplayUnit)DisplayUnits.TIME_SECONDS))});
        }
        for (CombustionFuelSource fuel : CombustionFuelRegister.INSTANCE.getFuels()) {
            for (FluidStack fluid : fuel.getFuels()) {
                registration.addIngredientInfo((Object)new FluidStack(fluid, 1600), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{ElectroTextUtils.jeiFluidTranslated("combustionchamberfuel", ChatFormatter.getChatDisplayShort((double)(fuel.getPowerMultiplier() * ElectroConstants.COMBUSTIONCHAMBER_JOULES_PER_TICK * 20.0 / 1000.0), (IDisplayUnit)DisplayUnits.WATT), ChatFormatter.formatFluidMilibuckets((double)fluid.getAmount()))});
            }
        }
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (RegistryObject fluid : ElectrodynamicsFluids.FLUIDS.getEntries()) {
            fluids.add(new FluidStack((Fluid)fluid.get(), 1000));
        }
        registration.addExtraIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fluids);
        ArrayList<GasStack> gases = new ArrayList<GasStack>();
        for (RegistryObject gas : ElectrodynamicsGases.GASES.getEntries()) {
            if (gas.get() == VoltaicGases.EMPTY.get()) continue;
            gases.add(new GasStack((Gas)gas.get(), 1000, 293, 1));
        }
        registration.addExtraIngredients((IIngredientType)VoltaicJeiTypes.GAS_STACK, gases);
    }
}

