/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import electrodynamics.prefab.utilities.object.CombustionFuelSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import voltaic.common.tags.VoltaicTags;

public class CombustionChamberFuelSourceProvider
implements DataProvider {
    public static final String LOC = "data/electrodynamics/machines/combustion_fuel/";
    private final PackOutput output;
    private final Map<String, JsonObject> jsons = new HashMap<String, JsonObject>();

    public CombustionChamberFuelSourceProvider(PackOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addFuels();
        Path parent = this.output.m_245114_().resolve(LOC);
        ArrayList<CompletableFuture> completed = new ArrayList<CompletableFuture>();
        for (Map.Entry<String, JsonObject> json : this.jsons.entrySet()) {
            completed.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)json.getValue()), (Path)parent.resolve(json.getKey() + ".json")));
        }
        return CompletableFuture.allOf((CompletableFuture[])completed.toArray(CompletableFuture[]::new));
    }

    private void addFuels() {
        this.jsons.put("ethanol", CombustionFuelSource.toJson((TagKey<Fluid>)VoltaicTags.Fluids.ETHANOL, 1, 1.0));
        this.jsons.put("hydrogen", CombustionFuelSource.toJson((TagKey<Fluid>)VoltaicTags.Fluids.HYDROGEN, 1000, 1.0));
    }

    public String m_6055_() {
        return "Combustion Chamber Fuel Sources";
    }
}

