/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.prefab.screen.component;

import com.mojang.blaze3d.systems.RenderSystem;
import electrodynamics.common.tile.pipelines.fluid.TileFluidPipeFilter;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.types.gauges.AbstractScreenComponentGauge;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenComponentFluidFilter
extends ScreenComponentGeneric {
    private final int index;

    public ScreenComponentFluidFilter(int x, int y, int index) {
        super((ITexture)AbstractScreenComponentGauge.GaugeTextures.BACKGROUND_DEFAULT, x, y);
        this.index = index;
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        ResourceLocation fluidText;
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        TileFluidPipeFilter filter = (TileFluidPipeFilter)((GenericContainerBlockEntity)((GenericScreen)this.gui).m_6262_()).getSafeHost();
        if (filter == null) {
            return;
        }
        SingleProperty property = filter.filteredFluids[this.index];
        FluidStack fluid = (FluidStack)property.getValue();
        if (!fluid.isEmpty() && (fluidText = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture()) != null) {
            ResourceLocation blocks = InventoryMenu.f_39692_;
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(blocks).apply(fluidText);
            RenderingUtils.bindTexture((ResourceLocation)sprite.m_247685_());
            int scale = AbstractScreenComponentGauge.GaugeTextures.BACKGROUND_DEFAULT.textureHeight() - 2;
            RenderingUtils.setShaderColor((Color)new Color(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid)));
            for (int i = 0; i < 16; i += 16) {
                for (int j = 0; j < scale; j += 16) {
                    int drawWidth = Math.min(this.texture.textureWidth() - 2 - i, 16);
                    int drawHeight = Math.min(scale - j, 16);
                    int drawX = guiWidth + this.xLocation + 1;
                    int drawY = guiHeight + this.yLocation - 1 + this.texture.textureHeight() - Math.min(scale - j, this.texture.textureHeight());
                    graphics.m_280159_(drawX, drawY, 0, drawWidth, drawHeight, sprite);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        graphics.m_280163_(AbstractScreenComponentGauge.GaugeTextures.LEVEL_DEFAULT.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation, (float)AbstractScreenComponentGauge.GaugeTextures.LEVEL_DEFAULT.textureU(), 0.0f, AbstractScreenComponentGauge.GaugeTextures.LEVEL_DEFAULT.textureWidth(), AbstractScreenComponentGauge.GaugeTextures.LEVEL_DEFAULT.textureHeight(), AbstractScreenComponentGauge.GaugeTextures.LEVEL_DEFAULT.imageWidth(), AbstractScreenComponentGauge.GaugeTextures.LEVEL_DEFAULT.imageHeight());
    }

    public void renderForeground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (!this.isPointInRegion(this.xLocation, this.yLocation, xAxis, yAxis, this.texture.textureWidth(), this.texture.textureHeight())) {
            return;
        }
        TileFluidPipeFilter filter = (TileFluidPipeFilter)((GenericContainerBlockEntity)((GenericScreen)this.gui).m_6262_()).getSafeHost();
        if (filter == null) {
            return;
        }
        SingleProperty property = filter.filteredFluids[this.index];
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        tooltips.add(Component.m_237115_((String)((FluidStack)property.getValue()).getTranslationKey()).m_7532_());
        graphics.m_280245_(this.gui.getFontRenderer(), tooltips, xAxis, yAxis);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActiveAndVisible() && this.isValidClick(button) && this.isInClickRegion(mouseX, mouseY)) {
            this.onMouseClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClick(button)) {
            this.onMouseRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void onMouseClick(double mouseX, double mouseY) {
        GenericScreen screen = (GenericScreen)this.gui;
        TileFluidPipeFilter filter = (TileFluidPipeFilter)((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost();
        if (filter == null) {
            return;
        }
        SingleProperty property = filter.filteredFluids[this.index];
        ItemStack holding = ((GenericContainer)screen.m_6262_()).m_142621_();
        if (holding.m_41619_()) {
            if (!Screen.m_96638_()) {
                return;
            }
            property.setValue((Object)FluidStack.EMPTY);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11778_, (float)1.0f));
            return;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)holding.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
        if (handler == CapabilityUtils.EMPTY_FLUID_ITEM) {
            return;
        }
        FluidStack taken = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (taken.isEmpty()) {
            return;
        }
        property.setValue((Object)taken);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11781_, (float)1.0f));
    }
}

