/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.prefab.sound.tickable;

import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.WorldUtils;

public class TickableSoundJetpack
extends AbstractTickableSoundInstance {
    private static final int MAX_DISTANCE = 10;
    private UUID originId;
    private Player originPlayer;

    public TickableSoundJetpack(UUID originPlayer) {
        super((SoundEvent)ElectrodynamicsSounds.SOUND_JETPACK.get(), SoundSource.PLAYERS, RandomSource.m_216327_());
        this.originId = originPlayer;
        this.f_119573_ = 0.5f;
        this.f_119574_ = 1.0f;
        this.f_119578_ = true;
    }

    public void m_7788_() {
        this.originPlayer = Minecraft.m_91087_().f_91073_.m_46003_(this.originId);
        if (this.checkStop()) {
            this.m_119609_();
            return;
        }
        this.f_119573_ = this.getPlayedVolume();
        this.f_119574_ = 1.0f;
    }

    public float getPlayedVolume() {
        ItemStack jetpack = this.originPlayer.m_6844_(EquipmentSlot.CHEST);
        if (jetpack.m_41782_() && jetpack.m_41783_().m_128471_("used")) {
            double distance = WorldUtils.distanceBetweenPositions((BlockPos)this.originPlayer.m_20183_(), (BlockPos)Minecraft.m_91087_().f_91074_.m_20183_());
            if (distance > 0.0 && distance <= 10.0) {
                return (float)(0.5 / distance);
            }
            if (distance <= 10.0) {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    protected boolean checkStop() {
        if (this.originPlayer == null || this.originPlayer.m_213877_()) {
            return true;
        }
        ItemStack jetpack = this.originPlayer.m_6844_(EquipmentSlot.CHEST);
        if (jetpack.m_41619_()) {
            return true;
        }
        return !ItemUtils.testItems((Item)jetpack.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_JETPACK.get()}) && !ItemUtils.testItems((Item)jetpack.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMBATCHESTPLATE.get()});
    }
}

