/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.particle;

import com.enderio.base.common.init.EIOParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public record RangeParticleData(int range, String color) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<RangeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<RangeParticleData>(){

        public RangeParticleData fromCommand(ParticleType<RangeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int range = reader.readInt();
            reader.expect(' ');
            String color = reader.readString();
            return new RangeParticleData(range, color);
        }

        public RangeParticleData fromNetwork(ParticleType<RangeParticleData> particleType, FriendlyByteBuf buffer) {
            return new RangeParticleData(buffer.readInt(), buffer.m_130277_());
        }
    };
    public static Codec<RangeParticleData> CODEC = RecordCodecBuilder.create(val -> val.group((App)Codec.INT.fieldOf("range").forGetter(data -> data.range), (App)Codec.STRING.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)val, RangeParticleData::new));

    public ParticleType<?> m_6012_() {
        return (ParticleType)EIOParticles.RANGE_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.range);
        buffer.m_130070_(this.color);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %s ", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.range, this.color);
    }
}

