/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.FixedScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CreativePowerBlockEntity
extends PoweredMachineBlockEntity {
    public static final FixedScalable CAPACITY = new FixedScalable(() -> Integer.MAX_VALUE);

    public CreativePowerBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Output, CAPACITY, FixedScalable.ZERO, type, worldPosition, blockState);
    }

    @Override
    protected MachineEnergyStorage createEnergyStorage(EnergyIOMode energyIOMode, Supplier<Integer> capacityKey, Supplier<Integer> useKey) {
        return new MachineEnergyStorage(this.getIOConfig(), energyIOMode, capacityKey, useKey){

            @Override
            public int getEnergyStored() {
                return this.getMaxEnergyStored() / 2;
            }
        };
    }

    @Override
    protected boolean isActive() {
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return null;
    }
}

