/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.recipe;

import com.enderio.EnderIO;
import com.enderio.core.common.recipes.EnderRecipe;
import com.enderio.core.common.util.JsonUtil;
import com.enderio.machines.common.blockentity.FluidTankBlockEntity;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TankRecipe
implements EnderRecipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final FluidStack fluid;
    private final boolean isEmptying;

    public TankRecipe(ResourceLocation id, Ingredient input, ItemStack output, FluidStack fluid, boolean isEmptying) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.fluid = fluid;
        this.isEmptying = isEmptying;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public boolean isEmptying() {
        return this.isEmptying;
    }

    public boolean matches(Container pContainer, Level pLevel) {
        if (this.isEmptying) {
            if (pContainer.getFluidTank().fill(this.fluid, IFluidHandler.FluidAction.SIMULATE) <= 0) {
                return false;
            }
            return this.input.test(FluidTankBlockEntity.FLUID_FILL_INPUT.getItemStack((net.minecraft.world.Container)pContainer));
        }
        if (pContainer.getFluidTank().drain(this.fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            return false;
        }
        return this.input.test(FluidTankBlockEntity.FLUID_DRAIN_INPUT.getItemStack((net.minecraft.world.Container)pContainer));
    }

    public ItemStack assemble(Container container, RegistryAccess registryAccess) {
        return null;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MachineRecipes.TANK.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MachineRecipes.TANK.type().get();
    }

    public static class Container
    extends RecipeWrapper {
        private final Supplier<MachineFluidTank> fluidTankSupplier;

        public Container(IItemHandlerModifiable inv, Supplier<MachineFluidTank> fluidTankSupplier) {
            super(inv);
            this.fluidTankSupplier = fluidTankSupplier;
        }

        public MachineFluidTank getFluidTank() {
            return this.fluidTankSupplier.get();
        }
    }

    public static class Serializer
    implements RecipeSerializer<TankRecipe> {
        public TankRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)serializedRecipe.get("input").getAsJsonObject());
            ItemStack output = JsonUtil.deserializeItemStackWithOldFormat(serializedRecipe.get("output"), true, true);
            JsonObject fluidJson = serializedRecipe.get("fluid").getAsJsonObject();
            ResourceLocation fluidId = new ResourceLocation(fluidJson.get("fluid").getAsString());
            FluidStack fluid = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId), fluidJson.get("amount").getAsInt());
            boolean isEmptying = serializedRecipe.get("is_emptying").getAsBoolean();
            return new TankRecipe(recipeId, input, output, fluid, isEmptying);
        }

        @Nullable
        public TankRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                ItemStack output = buffer.m_130267_();
                FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
                boolean isEmptying = buffer.readBoolean();
                return new TankRecipe(recipeId, input, output, fluid, isEmptying);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error reading tank recipe from packet.", (Throwable)ex);
                throw ex;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, TankRecipe recipe) {
            try {
                recipe.input.m_43923_(buffer);
                buffer.m_130055_(recipe.output);
                recipe.fluid.writeToPacket(buffer);
                buffer.writeBoolean(recipe.isEmptying);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing tank recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

