/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.blockentity.IPaintableBlockEntity;
import com.enderio.base.common.blockentity.SinglePaintedBlockEntity;
import com.enderio.base.common.util.PaintUtils;
import com.enderio.machines.common.blockentity.TravelAnchorBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PaintedTravelAnchorBlockEntity
extends TravelAnchorBlockEntity
implements IPaintableBlockEntity {
    @Nullable
    private Block paint;

    @Override
    @Nullable
    public Block getPaint() {
        return this.paint;
    }

    public PaintedTravelAnchorBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(SinglePaintedBlockEntity.PAINT, (Object)this.paint).build();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        Block oldPaint = this.paint;
        CompoundTag tag = pkt.m_131708_();
        if (tag == null) {
            return;
        }
        this.handleUpdateTag(tag);
        if (oldPaint != this.paint) {
            this.requestModelDataUpdate();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7731_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), 9);
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readPaint(tag);
    }

    @Override
    public void handleUpdateTag(CompoundTag syncData) {
        super.handleUpdateTag(syncData);
        this.readPaint(syncData);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writePaint(nbt);
        return nbt;
    }

    protected void readPaint(CompoundTag tag) {
        if (tag.m_128441_("Paint")) {
            this.paint = PaintUtils.getBlockFromRL(tag.m_128461_("Paint"));
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writePaint(tag);
    }

    protected void writePaint(CompoundTag tag) {
        if (this.paint != null) {
            tag.m_128359_("Paint", Objects.requireNonNull(BuiltInRegistries.f_256975_.m_7981_((Object)this.paint)).toString());
        }
    }
}

