/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.crafting.FluxStorageRecipe;

public class FluxStorageRecipeSerializer
implements RecipeSerializer<FluxStorageRecipe> {
    public static final FluxStorageRecipeSerializer INSTANCE = new FluxStorageRecipeSerializer();

    private FluxStorageRecipeSerializer() {
    }

    @Nonnull
    public FluxStorageRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        return new FluxStorageRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json));
    }

    @Nullable
    public FluxStorageRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
            if (recipe != null) {
                return new FluxStorageRecipe(recipe);
            }
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error("Error reading Flux Storage Recipe from Packet", (Throwable)e);
        }
        return null;
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull FluxStorageRecipe recipe) {
        try {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error("Error writing Flux Storage Recipe to packet.", (Throwable)e);
        }
    }
}

