/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedVerticalStairsModel
extends FramedBlockModel {
    private final StairsType type;
    private final Direction dir;

    public FramedVerticalStairsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (this.type == StairsType.VERTICAL && (quadDir == this.dir.m_122424_() || quadDir == this.dir.m_122427_())) {
            Direction cutDir = quadDir == this.dir.m_122424_() ? this.dir.m_122427_() : this.dir.m_122424_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir.m_122424_(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
        if (quadDir == Direction.UP && !this.type.isTop() || quadDir == Direction.DOWN && !this.type.isBottom()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.5f)).export(quadMap.get(quadDir));
        }
        if ((quadDir == this.dir.m_122424_() || quadDir == this.dir.m_122427_()) && this.type != StairsType.VERTICAL) {
            boolean opposite = quadDir == this.dir.m_122424_();
            Direction cutDir = opposite ? this.dir.m_122427_() : this.dir.m_122424_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).apply(Modifiers.cutSideUpDown(!this.type.isTop(), 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).apply(Modifiers.cutSideUpDown(this.type.isTop(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            cutDir = opposite ? this.dir.m_122428_() : this.dir;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).apply(Modifiers.cutSideUpDown(!this.type.isTop(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
        if (quadDir == Direction.UP && this.type.isTop() || quadDir == Direction.DOWN && this.type.isBottom()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.m_122428_(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.m_122427_(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
        if ((quadDir == this.dir || quadDir == this.dir.m_122428_()) && this.type != StairsType.VERTICAL) {
            boolean ccw = quadDir == this.dir.m_122428_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!this.type.isTop(), 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.type.isTop(), 0.5f)).apply(Modifiers.cutSideLeftRight(ccw ? this.dir.m_122424_() : this.dir.m_122427_(), 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

