/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.client.render.MantleRenderTypes;

public class FluidRenderer {
    public static TextureAtlasSprite getBlockSprite(ResourceLocation sprite) {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(sprite);
    }

    public static int withBlockLight(int combinedLight, int blockLight) {
        return combinedLight & 0xFFFF0000 | Math.max(blockLight << 4, combinedLight & 0xFFFF);
    }

    private static float boundUV(float value, boolean upper) {
        if ((value %= 1.0f) == 0.0f) {
            return upper ? 1.0f : 0.0f;
        }
        return value < 0.0f ? value + 1.0f : value;
    }

    public static void putTexturedQuad(VertexConsumer renderer, Matrix4f matrix, TextureAtlasSprite sprite, Vector3f from, Vector3f to, Direction face, int color, int brightness, int rotation, boolean flowing) {
        float u4;
        float v3;
        float u3;
        float maxV;
        float minV;
        float maxU;
        float minU;
        double size;
        float temp;
        float v1;
        float u2;
        float u1;
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        float v2 = switch (face) {
            default -> {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                yield z1;
            }
            case Direction.UP -> {
                u1 = x1;
                u2 = x2;
                v1 = -z1;
                yield -z2;
            }
            case Direction.NORTH -> {
                u1 = -x1;
                u2 = -x2;
                v1 = y1;
                yield y2;
            }
            case Direction.SOUTH -> {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                yield y2;
            }
            case Direction.WEST -> {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                yield y2;
            }
            case Direction.EAST -> {
                u1 = -z1;
                u2 = -z2;
                v1 = y1;
                yield y2;
            }
        };
        if (rotation == 0 || rotation == 270) {
            temp = v1;
            v1 = -v2;
            v2 = -temp;
        }
        if (rotation >= 180) {
            temp = u1;
            u1 = -u2;
            u2 = -temp;
        }
        boolean reverse = u1 > u2;
        u1 = FluidRenderer.boundUV(u1, reverse);
        u2 = FluidRenderer.boundUV(u2, !reverse);
        reverse = v1 > v2;
        v1 = FluidRenderer.boundUV(v1, reverse);
        v2 = FluidRenderer.boundUV(v2, !reverse);
        double d = size = flowing ? 8.0 : 16.0;
        if (rotation % 180 == 90) {
            minU = sprite.m_118367_((double)v1 * size);
            maxU = sprite.m_118367_((double)v2 * size);
            minV = sprite.m_118393_((double)u1 * size);
            maxV = sprite.m_118393_((double)u2 * size);
        } else {
            minU = sprite.m_118367_((double)u1 * size);
            maxU = sprite.m_118367_((double)u2 * size);
            minV = sprite.m_118393_((double)v1 * size);
            maxV = sprite.m_118393_((double)v2 * size);
        }
        float v4 = switch (rotation) {
            default -> {
                u1 = minU;
                v1 = maxV;
                u2 = minU;
                v2 = minV;
                u3 = maxU;
                v3 = minV;
                u4 = maxU;
                yield maxV;
            }
            case 90 -> {
                u1 = minU;
                v1 = minV;
                u2 = maxU;
                v2 = minV;
                u3 = maxU;
                v3 = maxV;
                u4 = minU;
                yield maxV;
            }
            case 180 -> {
                u1 = maxU;
                v1 = minV;
                u2 = maxU;
                v2 = maxV;
                u3 = minU;
                v3 = maxV;
                u4 = minU;
                yield minV;
            }
            case 270 -> {
                u1 = maxU;
                v1 = maxV;
                u2 = minU;
                v2 = maxV;
                u3 = minU;
                v3 = minV;
                u4 = maxU;
                yield minV;
            }
        };
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (face) {
            case DOWN: {
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case UP: {
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case NORTH: {
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case SOUTH: {
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case WEST: {
                renderer.m_252986_(matrix, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case EAST: {
                renderer.m_252986_(matrix, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                renderer.m_252986_(matrix, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
            }
        }
    }

    public static void renderCuboid(PoseStack matrices, VertexConsumer buffer, FluidCuboid cube, TextureAtlasSprite still, TextureAtlasSprite flowing, Vector3f from, Vector3f to, int color, int light, boolean isGas) {
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        int rotation = isGas ? 180 : 0;
        for (Direction dir : Direction.values()) {
            FluidCuboid.FluidFace face = cube.getFace(dir);
            if (face == null) continue;
            boolean isFlowing = face.isFlowing();
            int faceRot = (rotation + face.rotation()) % 360;
            FluidRenderer.putTexturedQuad(buffer, matrix, isFlowing ? flowing : still, from, to, dir, color, light, faceRot, isFlowing);
        }
    }

    public static void renderCuboids(PoseStack matrices, VertexConsumer buffer, List<FluidCuboid> cubes, FluidStack fluid, int light) {
        if (fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite still = FluidRenderer.getBlockSprite(clientFluid.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite(clientFluid.getFlowingTexture(fluid));
        int color = clientFluid.getTintColor(fluid);
        FluidType type = fluid.getFluid().getFluidType();
        light = FluidRenderer.withBlockLight(light, type.getLightLevel(fluid));
        boolean isGas = type.isLighterThanAir();
        for (FluidCuboid cube : cubes) {
            FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, isGas);
        }
    }

    public static void renderCuboid(PoseStack matrices, VertexConsumer buffer, FluidCuboid cube, float yOffset, TextureAtlasSprite still, TextureAtlasSprite flowing, int color, int light, boolean isGas) {
        if (yOffset != 0.0f) {
            matrices.m_85836_();
            matrices.m_252880_(0.0f, yOffset, 0.0f);
        }
        FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, isGas);
        if (yOffset != 0.0f) {
            matrices.m_85849_();
        }
    }

    public static void renderScaledCuboid(PoseStack matrices, MultiBufferSource buffer, FluidCuboid cube, FluidStack fluid, float offset, int capacity, int light, boolean flipGas) {
        if (fluid.isEmpty() || capacity <= 0) {
            return;
        }
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite still = FluidRenderer.getBlockSprite(clientFluid.getStillTexture(fluid));
        TextureAtlasSprite flowing = FluidRenderer.getBlockSprite(clientFluid.getFlowingTexture(fluid));
        FluidType type = fluid.getFluid().getFluidType();
        boolean isGas = type.isLighterThanAir();
        int color = clientFluid.getTintColor(fluid);
        light = FluidRenderer.withBlockLight(light, type.getLightLevel(fluid));
        Vector3f from = cube.getFromScaled();
        Vector3f to = cube.getToScaled();
        float minY = from.y();
        float maxY = to.y();
        float height = ((float)fluid.getAmount() - offset) / (float)capacity;
        if (isGas && flipGas) {
            from = new Vector3f((Vector3fc)from);
            from.y = maxY + height * (minY - maxY);
        } else {
            to = new Vector3f((Vector3fc)to);
            to.y = minY + height * (maxY - minY);
        }
        FluidRenderer.renderCuboid(matrices, buffer.m_6299_(MantleRenderTypes.FLUID), cube, still, flowing, from, to, color, light, isGas);
    }
}

