/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;

@NothingNullByDefault
public interface IIncrementalEnum<TYPE extends Enum<TYPE>> {
    default public TYPE getNext(Predicate<TYPE> isValid) {
        TYPE next = this.byIndex(this.ordinal() + 1);
        while (!isValid.test(next)) {
            if (next == this) {
                return next;
            }
            next = this.byIndex(((Enum)next).ordinal() + 1);
        }
        return next;
    }

    default public TYPE getPrevious(Predicate<TYPE> isValid) {
        TYPE previous = this.byIndex(this.ordinal() - 1);
        while (!isValid.test(previous)) {
            if (previous == this) {
                return previous;
            }
            previous = this.byIndex(((Enum)previous).ordinal() - 1);
        }
        return previous;
    }

    public TYPE byIndex(int var1);

    public int ordinal();

    default public TYPE getNext() {
        return (TYPE)this.getNext(ConstantPredicates.alwaysTrue());
    }

    default public TYPE getPrevious() {
        return (TYPE)this.getPrevious(ConstantPredicates.alwaysTrue());
    }

    default public TYPE adjust(int shift) {
        return (TYPE)(shift == 0 ? (Enum)((Object)this) : this.byIndex(this.ordinal() + shift));
    }

    default public TYPE adjust(int shift, Predicate<TYPE> isValid) {
        Enum result = (Enum)((Object)this);
        while (shift < 0) {
            ++shift;
            result = ((IIncrementalEnum)((Object)result)).getPrevious(isValid);
        }
        while (shift > 0) {
            --shift;
            result = ((IIncrementalEnum)((Object)result)).getNext(isValid);
        }
        return (TYPE)result;
    }
}

