/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import mekanism.common.lib.distribution.SplitInfo;

public class LongSplitInfo
extends SplitInfo<Long> {
    private long amountToSplit;
    private long amountPerTarget;
    private long sentSoFar;

    public LongSplitInfo(long amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit;
        this.amountPerTarget = this.toSplitAmong == 0 ? 0L : amountToSplit / (long)this.toSplitAmong;
    }

    @Override
    public void send(Long amountNeeded) {
        this.amountToSplit -= amountNeeded.longValue();
        this.sentSoFar += amountNeeded.longValue();
        --this.toSplitAmong;
        if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
            long amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit / (long)this.toSplitAmong;
            if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public Long getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public Long getRemainderAmount() {
        return this.toSplitAmong == 0 ? this.amountPerTarget : this.amountPerTarget + this.amountToSplit % (long)this.toSplitAmong;
    }

    @Override
    public Long getTotalSent() {
        return this.sentSoFar;
    }
}

