/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class AugmentHandler {
    private static final AbilityCache ABILITY_CACHE = new AbilityCache();

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).m_21224_()) {
            Level level = player.m_9236_();
            List<Augment> augments = AugmentUtils.getArmorAugments(player);
            for (Augment augment : augments) {
                augment.onPlayerTick(level, player, ABILITY_CACHE);
            }
            for (String string : ABILITY_CACHE.getCachedAbilities(player)) {
                if (!augments.stream().noneMatch(a -> string.equals(a.getId().toString()))) continue;
                ABILITY_CACHE.remove(string, player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = player.m_9236_();
            for (Augment augment : AugmentUtils.getArmorAugments(player)) {
                augment.onPlayerFall(level, player, event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        for (String augment : ABILITY_CACHE.getCachedAbilities(player)) {
            ABILITY_CACHE.removeQuietly(augment, player);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (String augment : ABILITY_CACHE.getCachedAbilities(player)) {
                ABILITY_CACHE.removeQuietly(augment, player);
            }
        }
    }
}

